block('b-feed-filters-table')(

    js()(true),

    content()(function() {

        var group = this.ctx.group,
            campaignIsArchived = this.ctx.campaignIsArchived,
            // Если флаг "Мало показов" то показываем предупреждение, вместо статистики (DIRECT-61956)
            statColumns = this.ctx.showStat && +group.is_bs_rarely_loaded == 0 ?
                              group.adgroup_type == 'performance' ?
                                      ['ctx_clicks'] :
                                      ['ctx_shows', 'ctx_clicks', 'ctx_ctr'] :
                              [];

        return [
            {
                block: 'b-paranja',
                mods: { visible: 'yes' }
            },
            {
                elem: 'table',
                content: [
                    {
                        elem: 'head',
                        content: {
                            elem: 'row',
                            //DIRECT-54211 - временно закрываем показы и ctr для смартов
                            statColumns: statColumns,
                            group: group,
                            hasSortableColumns: this.ctx.group.feed_filters.length > 1,
                            currency: this.ctx.currency,
                            campaignIsArchived: campaignIsArchived
                        }
                    },
                    {
                        elem: 'body',
                        state: 'active',
                        group: this.ctx.group,
                        nowOptimizingBy: this.ctx.nowOptimizingBy,
                        showStat: this.ctx.showStat,
                        campaignIsArchived: campaignIsArchived,
                        platform: this.ctx.platform
                    },
                    {
                        elem: 'body',
                        state: 'suspended',
                        group: this.ctx.group,
                        nowOptimizingBy: this.ctx.nowOptimizingBy,
                        showStat: this.ctx.showStat,
                        campaignIsArchived: campaignIsArchived,
                        platform: this.ctx.platform
                    }
                ]
            }
        ];
    }),

    // тело в отличии от заголовка реализуется отдельным блоком b-feed-filters-group
    elem('body').def()(function() {
        return applyCtx({
            block: 'b-feed-filters-group',
            mods: {
                state: u.beminize(this.ctx.state),
                strategy: this.mods.strategy
            },
            group: this.ctx.group,
            nowOptimizingBy: this.ctx.nowOptimizingBy,
            showStat: this.ctx.showStat,
            campaignIsArchived: this.ctx.campaignIsArchived,
            platform: this.ctx.platform
        });
    }),

    elem('cell')(
        elemMod('content', 'filter')(

            content()(function() {
                return iget2('b-feed-filters-table', 'filtry', 'Фильтры');
            }),

            // сортировка по названию фильтра
            elemMod('sortable', 'yes').content()(function() {
                return {
                    block: 'b-phrases-list-sort',
                    elem: 'sort-link',
                    elemMods: {
                        name: 'filter-name',
                        sort: 'up'
                    },
                    title: applyNext()
                };
            })
        ),

        elemMod('content', 'stat')(

            elemMod('column', 'ctx-shows').content()(function() { return iget2('b-feed-filters-table', 'pokazy', 'Показы'); }),

            elemMod('column', 'ctx-clicks').content()(function() { return iget2('b-feed-filters-table', 'kliki', 'Клики'); }),

            elemMod('column', 'ctx-ctr').content()(function() { return iget2('b-feed-filters-table', 'ctr', 'CTR'); }),

            // сортировка по колонкам статистики
            elemMod('sortable', 'yes').match(function() { return this.elemMods.column }).content()(function() {
                return {
                    block: 'b-phrases-list-sort',
                    elem: 'sort-link',
                    elemMods: {
                        name: this.elemMods.column
                    },
                    title: applyNext()
                };
            })
        ),

        elemMod('content', 'price')(
            elemMod('strategy', 'default').content()(function() { return ''; }),

            elemMod('strategy', 'search').content()(function() {
                return iget2('b-feed-filters-table', 'bid-header', 'Ставка, {foo}', {
                    foo: u.currencies.get(this.ctx.currency).name
                });
            }),

            elemMod('strategy', 'net').content()(function() {
                return iget2('b-feed-filters-table', 'context-bid-header', 'Ставка, в сетях {foo}', {
                    foo: u.currencies.get(this.ctx.currency).name
                });
            }),

            elemMod('strategy', 'avg-cpc').content()(function() {
                return iget2('b-feed-filters-table', 'cpc-s', 'CPC, {foo}', {
                    foo: u.currencies.get(this.ctx.currency).name
                });
            }),

            elemMod('strategy', 'different-places').content()(function() {
                return iget2('b-feed-filters-table', 'bid-header', 'Ставка, {foo}', {
                    foo: u.currencies.get(this.ctx.currency).name
                });
            }),

            elemMod('strategy', 'avg-cpa').content()(function() {
                return iget2('b-feed-filters-table', 'bid-header', 'Ставка, {foo}', {
                    foo: u.currencies.get(this.ctx.currency).name
                });
            })
        ),

        elemMod('type', 'gap-cell').content()('&nbsp;')
    )
);
