block('b-feed-filters')(
    def()(function() {
        return applyNext({
            state: this.mods.state
        });
    }),

    js()(function() {
        return {
            modelParams: {
                name: 'b-feed-filters',
                id: this.ctx.groupId
            },
            groupModelParam: this.ctx.groupModelParam,
            errorPath: this.ctx.errorPath
        };
    }),

    mix()([
        {
            block: 'i-controls-overseer',
            js: true
        },
        {
            block: 'i-list-style',
            mods: {
                style: 'decimal-outside'
            }
        }
    ]),

    content()(function() {
        return [
            {
                elem: 'items',
                tag: 'ul',
                mix: {
                    block: 'i-list',
                    elem: 'items'
                },
                content: this.ctx.filters.map(function(filter, index) {
                    return {
                        block: 'b-feed-filters',
                        elem: 'item',
                        filter: filter,
                        errorPath: this.ctx.errorPath + '[' + index + ']'
                    };
                }, this)
            },
            {
                elem: 'add'
            }
        ];
    }),

    elem('add').replace()(function() {
        return [
            {
                block: 'b-control-add-button',
                mix: {
                    block: 'b-feed-filters',
                    elem: 'add-control'
                },
                mods: {
                    state: this.state
                },
                content: iget2('b-feed-filters', 'novyy-filtr', 'Новый фильтр')
            },
            {
                elem: 'add-hint',
                content: iget2('b-feed-filters', 'vyberite-fid', 'Выберите фид')
            }
        ];
    }),

    elem('item')(
        tag()('li'),
        mix()({
            block: 'i-list',
            elem: 'item'
        }),
        content()(function() {
            var filter = this.ctx.filter,
                isDynamicGroup = this.ctx.filter.adgroup_type === 'dynamic';

            return [
                {
                    block: 'b-feed-filter',
                    mods: { detailed: 'yes' },
                    noRetargeting: isDynamicGroup || this.ctx.filter.retargetings.length === 0,
                    noTargetAudience: isDynamicGroup,
                    filter: filter,
                    editControl: {
                        block: 'b-control-edit-button',
                        data: {
                            itemId: filter.filter_id
                        },
                        content: iget2('b-feed-filters', 'izmenit', 'изменить')
                    }
                },
                {
                    block: 'b-control-remove-button',
                    mods: {
                        icon: 'basket'
                    },
                    data: {
                        itemId: filter.filter_id
                    },
                    mix: {
                        block: 'b-feed-filters',
                        elem: 'item-remove'
                    }
                },
                {
                    block: 'b-error-message',
                    js: { path: this.ctx.errorPath }
                }
            ];
        })
    )
);
