BEM.MODEL.decl({ name: 'b-feed-filters', baseModel: 'vm-sync-dm' }, {
    /**
     * коллекция условий
     */
    items: {
        type: 'models-list',
        modelName: 'b-feed-filter'
    },

    /**
     * флаг, можно ли добавлять в список
     */
    canAddFilter: {
        type: 'boolean',
        dependsFrom: 'items',
        internal: true,
        calculate: function() {
            return this.get('items').length() < 50;
        }
    }

}, {

    init: function(dmGroupModelParams) {
        this.set('_dmDecl', dmGroupModelParams);

        return this.__base();
    },

    /**
     * Готовит данные для синхронизации в DM
     */
    prepareDataToDM: function(data) {
        return {
            feed_filters: data.items.map(function(item) {
                return u._.extend(item, {
                    from_tab: item.tab
                });
            })
        }
    },

    /**
     * Готовит данные для синхронизации из DM
     */
    prepareDataFromDM: function(data) {
        return {
            items: data.feed_filters.map(function(filter) {
                return u._.extend(filter, {
                    tab: filter.from_tab,
                    conditionTree: filter.condition_tree
                });
            })
        };
    },

    getFeedData: function() {
        var feedDM = this.getDM().getFeedDM();

        return feedDM ? feedDM.toJSON() : {};
    },

    getCurrency: function() {
        return this.getDM().getCurrency();
    },

    getStrategy: function() {
        return this.getDM().getStrategy();
    },

    getMetrikaCounters: function() {
        return this.getDM().getMetrikaCounters();
    },

    /**
     * Обращается к DM для создания новой модели фильтра
     * @returns {String} - идентификатор созданной модели
     */
    createFeedFilter: function() {
        return this.getDM().addFeedFilter();
    },

    /**
     * Обращается к DM для сохранения модели фильтра
     * @returns {$.Deferred} - пустой объект или объект с ошибкой
     */
    saveFeedFilter: function(data) {
        return this.getDM().saveFeedFilter(data);
    },

    /**
     * Обращается к DM для удаления модели фильтра
     */
    destroyFeedFilter: function(id) {
        this.get('items').getById(id).destruct();

        this.getDM().destroyFeedFilter(id);
    },

    /**
     * Удаляет все фильтры из своей модели и DM группы
     */
    destroyAllFeedFilters: function() {
        this.getDM().destroyAllFeedFilters();
        this.syncFromDM();
    }
});
