block('b-feeds-history').elem('feeds-table')(

    match(function() { return this.ctx.feedHistory; })(
        content()(function() {
            return iget2('b-feeds-history', 'detalizaciya-otsutstvuet', 'Детализация отсутствует');
        })
    ),

    match(function() { return this.ctx.feedHistory && this.ctx.feedHistory.length; })(
        content()(function() {
            this.ctx.feedHistory = this.ctx.feedHistory.filter(function(item) {
                //DIRECT-55262 - показываем только те строки в которых есть ошибки
                //или предупреждения
                return !!(item.parseResults.errors.length || item.parseResults.warnings.length);
            });
            //@heliarian DIRECT-55659 - пока выводим только первую ошибку
            this.ctx.feedHistory = this.ctx.feedHistory.slice(0, 1);

            return [
                {
                    block: 'b-layout-table',
                    mix: {
                        block: 'b-style-table', mods: { theme: 'gray-list' }
                    },
                    content: [
                        {
                            elem: 'row',
                            mix: [
                                {
                                    block: 'b-style-table', elem: 'head'
                                },
                                {
                                    block: 'b-feeds-history', elem: 'head-row'
                                }
                            ],
                            content: [
                                iget2('b-feeds-history', 'data', 'Дата'),
                                iget2('b-feeds-history', 'nazvanie-fayla', 'Название файла'),
                                iget2('b-feeds-history', 'status', 'Статус'),
                                iget2('b-feeds-history', 'podrobnee', 'Подробнее')
                            ].map(function(item, index) {
                                return {
                                    elem: 'cell', mix: [
                                        {
                                            block: 'b-style-table', elem: 'cell'
                                        }, {
                                            block: 'b-feeds-history', elem: 'cell', elemMods: {
                                                // сжимаем первые две ячейки
                                                tight: index < 2 ? 'yes' : ''
                                            }
                                        }
                                    ], content: item
                                };
                            }, this)
                        },
                        this.ctx.feedHistory.map(function(item, index) {
                            return {
                                elem: 'row',
                                mix: { block: 'b-style-table', elem: 'row' },
                                content: [
                                    item.createdAt,
                                    {
                                        block: 'b-feeds-history',
                                        elem: 'file-name',
                                        attrs: { title: u.escapeHTML(this.ctx.feed.fileName) },
                                        content: u.hellipSplit(this.ctx.feed.fileName, 30, u.escapeHTML)
                                    },
                                    [
                                        item.parseResults.errors.length ?
                                            {
                                                elem: 'errors',
                                                content: [
                                                    //@heliarian - пока ошибки не плказываем
                                                    //{
                                                    //    block: 'b-icon-text',
                                                    //    mix: {
                                                    //        block: 'b-feeds-history',
                                                    //        elem: 'status-title'
                                                    //    },
                                                    //    content: iget('Ошибки')
                                                    //},
                                                    {
                                                        block: 'b-feeds-history',
                                                        elem: 'status-title',
                                                        content: iget2('b-feeds-history', 'oshibka', 'Ошибка') + ':'
                                                    },
                                                    //показываем читабельный текст про ошибку
                                                    item.parseResults.errors.map(function(error) {
                                                        return {
                                                            content: u['i-feeds-errors-dictionary'].getErrorText(error)
                                                        };
                                                    })
                                                ]
                                            } :
                                            '',
                                        item.parseResults.warnings.length ?
                                            {
                                                elem: 'warnings',
                                                content: [
                                                    //@heliarian - пока иконки не показываем, может потом откроем
                                                    //{
                                                    //    block: 'b-icon-text',
                                                    //    mix: {
                                                    //        block: 'b-feeds-history',
                                                    //        elem: 'status-title'
                                                    //    },
                                                    //    content: iget('Предупреждения')
                                                    //},
                                                    {
                                                        block: 'b-feeds-history',
                                                        elem: 'status-title',
                                                        content: iget2('b-feeds-history', 'preduprezhdeniya', 'Предупреждения')
                                                    },
                                                    item.parseResults.warnings.map(function(warning) {
                                                        return {
                                                            block: 'b-feeds-history',
                                                            elem: 'warning',
                                                            content: u.escapeHTML(warning)
                                                        };
                                                    })
                                                ]
                                            } :
                                            ''
                                    ],
                                    [
                                        item.parseResults.errors.length ?
                                            {
                                                content: {
                                                    elem: 'errors',
                                                    content: {
                                                        block: 'b-feeds-history',
                                                        elem: 'error',
                                                        //показываем подробную информацию об ошибке с кодами и кучей странных символов для умных пользователей
                                                        content: item.parseResults.errors.map(function(error) {
                                                            return {
                                                                block: 'b-feeds-history',
                                                                elem: 'error',
                                                                content: u.escapeHTML(error.message)
                                                            };
                                                        })
                                                    }
                                                }
                                            } :
                                            ''

                                    ]
                                ].map(function(item, index) {
                                    return {
                                        elem: 'cell',
                                        mix: [
                                            {
                                                block: 'b-style-table',
                                                elem: 'cell'
                                            },
                                            {
                                                block: 'b-feeds-history',
                                                elem: 'cell',
                                                elemMods: {
                                                    // сжимаем первые две ячейки
                                                    tight: index < 2 ? 'yes' : ''
                                                }
                                            }
                                        ],
                                        content: item
                                    };
                                })
                            };
                        }, this)
                    ]
                }
                //todo@heliarian - подключить пейджер после реализации DIRECT-49117
                //{
                //    block: 'b-pager2',
                //    mix: [
                //        {
                //            block: 'b-feeds-history', elem: 'pager'
                //        }
                //    ],
                //    mods: {
                //        type: 'js'
                //    },
                //    startFrom: 1,
                //    currentPage: this.ctx.pagerParams.page,
                //    totalPages: this.ctx.pagerParams.totalPages,
                //    pageUrl: this.ctx.pagerParams.pageUrl.replace('(\?|&)page=[^&]*(&|$)', '$2')
                //}
            ];
        })
    )
);
