BEM.DOM.decl({ block: 'b-feeds-history', baseBlock: 'i-glue' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            // id фида, опредаляется из url и не меняется в процессе работы блока
            this._feedId = undefined;

            // кол-во фидов на странице
            this._rowsPerPage = this.params.rowsPerPage;

            // номер текущей страницы
            this._page = 1;

            this._paranja = this.findBlockOn('paranja', 'b-paranja');

            this._initEvents();
        }
    },

    /**
     * Восстанавливает состояние блока по url параметрам при хождении по истории
     * @param {Object} stateObj объект с параметрами состояния
     * @param {String} stateObj.feed_id идентификатор фида
     * @param {String|Number} [stateObj.page] номер страницы
     * @deprecated удалить и обновлять состояние через view-модель
     * @private
     */
    updateState: function(stateObj) {
        this._feedId = +stateObj.feed_id;
        this._page = +stateObj.page || 1;

        this.render();
    },

    /**
     * Отрисовывает список фидов с пагинацией (если есть) согласно
     * текущему состоянию блока
     * @fires render:before событие до перерисовки
     * @fires render:after событие после перерисовки
     * @deprecated сделать приватным
     */
    render: function() {
        this.trigger('render:before');

        this.model.getHistory(this._feedId, this._page, this._rowsPerPage).then(function(json) {
            BEM.DOM.replace(this.findElem('feeds-table'), BEMHTML.apply({
                block: 'b-feeds-history',
                elem: 'feeds-table',
                feed: json.feed,
                feedHistory: json.feedHistory,
                pagerParams: {
                    page: this._page,
                    rowsPerPage: this._rowsPerPage,
                    totalPages: json.totalCount,
                    pageUrl: u.getCurrentUrl()
                }
            }));

            this.trigger('render:after');
        }.bind(this));
    },

    /**
     * Инициализирует события блока до и после перерисовки, а также
     * подписывается на событие popstate для восстановления параметров блока
     * при хождении по истории
     * @private
     */
    _initEvents: function() {
        // перед перерисовкой полностью блокируем интерфейс пока идет запрос за новыми данными
        this.on('render:before', function() {
            this._paranja.setMod('visible', 'yes');
        }, this);

        // после перерисовки инициализируем события на пейджере и даём доступ к интерфейсу
        this.on('render:after', function() {
            this._initPagination();

            this._paranja.delMod('visible');
        }, this);
    },

    /**
     * Инициализирует пейджер, если он будет найден на странице
     * @private
     */
    _initPagination: function() {
        var pager = this.findBlockInside('pager', 'b-pager2');

        // подписываемся на пейджер, если он есть
        pager && pager.bindTo('page', 'click', function(e) {
            e.preventDefault();

            this._page = +u.parseUrl(e.data.domElem.attr('href')).query.page;

            this._triggerStateChange();

            this.render();

            // скролим станицу в топ таблицы
            this.domElem.get(0).scrollIntoView();
        }.bind(this));
    },

    /**
     * Сохраняет состояние истории при сортировке, фильтрации и переходу по пейджер
     * @private
     */
    _triggerStateChange: function() {
        this.trigger('stateChange', {
            page: this._page
        });
    }

});
