r105527
#b-feeds-history#

##Описание##
Таблица с историей фида.

При вставке на страницу после инициализации нужно вызывать метод перерисовки `render`, тогда блок отправляет запрос к 
серверу для получения истории и обновляет свое содержимое.

###Автор### 
[coffeeich](https://staff.yandex-team.ru/coffeeich)
[eemelin](https://staff.yandex-team.ru/eemelin)

###Где используется###
Используется как основной блок page-блока `p-feeds-history`.

###Модели###
Содержимое блока регулируется состоянием его view-модели, которая в свою очередь использует в качестве источника данных
модель данных, способную запрашивать с сервера список фидов. Процесс удаления view-модель так же делегирует модели данных.
    
* `dm-feed-history` - модель с данными истории фидов
* `b-feeds-history.vm` - view-модель списка истории фидов

##Как пользоваться и расширять##
Как расширить блок, hints and tricks

##Roadmap & known issues##

Не был произведён рефакторинг блока. Нужно сделать как в `b-feeds-list`, то есть вместо восстановления состояния
блока через вызов метода `updateState` перенести свойства состояния во view-модели этого блока, после чего уже
реализовать поведедение с реакцией на изменения во view-модели.

Избавиться от вызова `render` для перерисовки, сделать как в `b-feeds-list` - перерисовка при инициализации из 
текущего состояния во view-модели.

Написать тесты.

##Пример##

BEMHTML:

```

    {
        block: 'b-feeds-history'
    }
```

JS:

```

    var block = ...
    
    // @deprecated: 
    block.render();
    
    // переключится на вторую страницу: запрос к серверу через DM и перерисовка
    block.updateState({ page: 2 });
    // @todo: block.model.set('page', 2);
    
    // переключиться на другой фид
    block.updateState({ feed_id: 1234 });
    // @todo: block.model.set('feedId', 1234);
```
