BEM.MODEL.decl({ name: 'b-feeds-history', baseModel: 'vm-sync-dm' }, {

    // фид
    feed: {
        type: 'model',
        modelName: 'vm-feed'
    },

    // список фидов
    feedHistory: {
        type: 'models-list',
        modelName: 'vm-feed-timeline'
    },

    // полное количество фидов
    totalCount: {
        type: 'number',
        default: 0
    },

    /**
     * декларация DM модели
     */
    _dmDecl: {
        type: 'string',
        internal: true,
        value: 'dm-feed-history'
    }

}, {

    syncFromDM: function() {
        this.__base.apply(this, arguments);

        this.get('feed').syncFromDM();
        this.get('feedHistory').forEach(function(item) {
            item.syncFromDM();
        });
    },

    prepareDataFromDM: function(data) {
        return {
            feed: { feedId: data.feed.feed_id },
            feedHistory: data.feed_history.map(function(item) { return { hid: item.hid }; }),
            totalCount: data.total_count
        };
    },

    getHistory: function(feedId, page, count) {
        return this.getDM().syncFromServer(feedId, page, count).then(function() {
            this.syncFromDM();

            return this.toJSON();
        }.bind(this));
    }

});
