/**
 * Элемент со списком привязвнных к фиду кампаний
 * Если количество кампаний менее двух, то в качестве контента будем иметь
 * название кампании с указанием её идентификатора, если кампаний более одной, то
 * контентом будет кнопка-тоглер для показа попапа со списком кампаний при нажатии на неё
 * @param {Object[]} campaigns список объектов кампаний
 */
block('b-feeds-list').elem('campaigns')(

    content()(function() {
        var campaigns = this.ctx.campaigns,
            campaign = campaigns[0],
            isPopupMode = this.ctx.isPopupMode;

        if (!campaign) return '&mdash;';

        if (campaigns.length > 1) {
            return {
                block: 'button',
                mods: { pseudo: 'yes' },
                mix: {
                    block: 'b-feeds-list',
                    elem: 'campaigns-popup-button',
                    js: { campaigns: campaigns }
                },
                content: iget2('b-feeds-list', 'vse-mdash-s', 'Все &mdash; {foo}', {
                    foo: campaigns.length
                })
            };
        }

        return [
            {
                elem: 'campaign-name',
                content: {
                    block: 'link',
                    url: u.getUrl('showCamp', {
                        cid: campaign.cid,
                        ulogin: u.consts('ulogin')
                    }),
                    target: isPopupMode ? '_blank' : '_self',
                    title: u.escapeHTML(campaign.name),
                    content: u.hellipCut(campaign.name, 35, u.escapeHTML)
                }
            },
            {
                elem: 'campaign-cid',
                content: [iget2('b-feeds-list', 'no', '№'), '&nbsp;', campaign.cid]
            }
        ];
    }),

    elemMod('list', 'yes').content()(function() {
        var isPopupMode = this.ctx.isPopupMode;

        return this.ctx.campaigns.map(function(campaign) {
            return {
                elem: 'campaign-popup-item',
                content: [
                    {
                        block: 'link',
                        url: u.getUrl('showCamp', {
                            cid: campaign.cid,
                            ulogin: u.consts('ulogin')
                        }),
                        target: isPopupMode ? '_blank' : '_self',
                        title: u.escapeHTML(campaign.name),
                        content: u.hellipCut(campaign.name, 150, u.escapeHTML)
                    },
                    '&nbsp;(',
                    iget2('b-feeds-list', 'no', '№'),
                    '&nbsp;',
                    campaign.cid,
                    ')'
                ]
            };
        });
    })
);
