/**
 * Элемент с таблицей списка фидов
 * Если не передана модель, то блок не будет иметь контента
 * Если нет фидов, то вместо таблицы отобразится надпись:
 *  - по умолчанию о том, что фиды отсутствуют
 *  - при поиске о том, что ничего не найдено
 * @param {Object} [model] объект фида
 * @param {String} [pageUrl] url текущей страницы для формирования ссылки пейджера
 */

block('b-feeds-list').elem('feeds-table').match(function() { return this.ctx.model; })(

    mix()({
        block: 'i-glue',
        js: { modelParams: { name: 'b-feeds-list' } }
    }),

    def()(function() {
        return applyNext({
            'ctx.ignored': this.ctx.model.items.reduce(function(ignored, item, index) {
                if (/^(New|Updating)$/.test(item.status) || !!item.campaigns.length) {
                    ignored[index] = true;
                }

                return ignored;
            }, {})
        });
    }),

    content()(function() {
        return iget2('b-feeds-list', 'fidy-otsutstvuyut', 'Фиды отсутствуют');
    }),

    match(function() {
        return this.ctx.model && this.ctx.model.search;
    }).content()(function() {
        return iget2('b-feeds-list', 'po-vashemu-zaprosu-nichego', 'По вашему запросу ничего не найдено');
    }),

    match(function() {
        return this.ctx.model && this.ctx.model.items.length;
    }).content()(function() {
        var ctx = this.ctx,
            model = ctx.model,
            isPopupMode = ctx.isPopupMode;

        return [
            {
                block: 'b-layout-table',
                mix: [
                    {
                        block: 'b-style-table',
                        mods: { theme: 'gray-list' }
                    },
                    {
                        block: 'b-checkboxes-group',
                        mods: { ignored: 'yes' },
                        js: {
                            ignored: ctx.ignored,
                            live: false
                        }
                    }
                ],
                content: [
                    {
                        elem: 'row',
                        mix: [
                            {
                                block: 'b-style-table',
                                elem: 'head'
                            },
                            {
                                block: 'b-feeds-list',
                                elem: 'head-row'
                            }
                        ],
                        content: [
                            {
                                block: 'checkbox',
                                mix: {
                                    block: 'b-checkboxes-group',
                                    elem: 'item'
                                },
                                checkboxAttrs: { autocomplete: 'off' }
                            },
                            [
                                {
                                    block: 'b-feeds-list',
                                    elem: 'sort-link',
                                    model: model,
                                    col: 'name',
                                    content: iget2('b-feeds-list', 'nazvanie-fida', 'Название фида')
                                },
                                ' / ',
                                {
                                    block: 'b-feeds-list',
                                    elem: 'sort-link',
                                    model: model,
                                    col: 'id',
                                    isDefaultCol: true,
                                    content: iget2('b-feeds-list', 'id', 'ID')
                                }
                            ],
                            {
                                block: 'b-feeds-list',
                                elem: 'sort-link',
                                model: this.ctx.model,
                                col: 'business_type',
                                content: iget2('b-feeds-list', 'tip', 'Тип')
                            },
                            {
                                block: 'b-feeds-list',
                                elem: 'sort-link',
                                model: model,
                                col: 'last_change',
                                content: iget2('b-feeds-list', 'data', 'Дата')
                            },
                            iget2('b-feeds-list', 'v-kampaniyah', 'В кампаниях'),
                            iget2('b-feeds-list', 'source', 'Источник данных'),
                            {
                                block: 'b-feeds-list',
                                elem: 'sort-link',
                                model: model,
                                col: 'offers_count',
                                content: iget2('b-feeds-list', 'kolichestvo-poziciy-v-fide', 'Количество позиций в фиде')
                            },
                            iget2('b-feeds-list', 'status', 'Статус')
                        ].map(function(item, index) {
                            return {
                                elem: 'cell',
                                mix: [
                                    {
                                        block: 'b-style-table',
                                        elem: 'cell'
                                    },
                                    {
                                        block: 'b-feeds-list',
                                        elem: 'cell',
                                        elemMods: {
                                            // сжимаем первую ячейку
                                            tiny: index === 0 ? 'yes' : ''
                                        }
                                    }
                                ],
                                attrs: index === 1 ? { colspan: 2 } : {},
                                content: item
                            };
                        }, this)
                    },
                    model.items.map(function(item, index) {
                        var url = item.url,
                            source = item.source,
                            fileName = item.fileName,
                            isReadOnly = item.isReadOnly,
                            sourceName = source === 'file' ? fileName : url;

                        return {
                            elem: 'row',
                            mix: [
                                {
                                    block: 'b-style-table',
                                    elem: 'row'
                                },
                                {
                                    block: 'b-feeds-list',
                                    elem: 'row',
                                    elemMods: { status: u.beminize(item.status) }
                                }
                            ],
                            content: [
                                {
                                    block: 'checkbox',
                                    mods: {
                                        checked: ~this.ctx.model.selected.indexOf(item.feedId) ? 'yes' : '',
                                        disabled: this.ctx.ignored[index] ? 'yes' : ''
                                    },
                                    mix: {
                                        block: 'b-checkboxes-group',
                                        elem: 'item'
                                    },
                                    checkboxAttrs: {
                                        autocomplete: 'off',
                                        value: item.feedId
                                    }
                                },
                                {
                                    block: 'b-feeds-list',
                                    elem: 'feed-count-num',
                                    content: [(this.ctx.model.page - 1) * this.ctx.model.rowsPerPage + index + 1, '.']
                                },
                                [
                                    {
                                        block: 'b-feeds-list',
                                        elem: 'feed-name',
                                        attrs: { title: u.escapeHTML(item.name) },
                                        content: [
                                            u.highlight(
                                                u.hellipCut(item.name, 35, u.escapeHTML),
                                                u.escapeHTML(model.search),
                                                {
                                                    decorator: function(search) {
                                                        return {
                                                            block: 'b-search-on-list',
                                                            elem: 'hlted',
                                                            content: search
                                                        };
                                                    }
                                                }),
                                            {
                                                block: 'b-feeds-list',
                                                elem: 'feed-id',
                                                content: iget2('b-feeds-list', 'id-id', '(ID {id})', {
                                                    id: u.highlight(item.feedId + '', model.search, {
                                                        global: false,
                                                        decorator: function(search) {
                                                            return {
                                                                block: 'b-search-on-list',
                                                                elem: 'hlted',
                                                                content: search
                                                            };
                                                        }
                                                    })
                                                })
                                            }
                                        ]
                                    },
                                    !isReadOnly && source !== 'site' && {
                                        block: 'button',
                                        mods: {
                                            size: 'xs',
                                            pseudo: 'yes',
                                            theme: 'normal',
                                            disabled: !model.allowEditFeeds || model.lockEdit ? 'yes' : ''
                                        },
                                        mix: [
                                            {
                                                block: 'b-feeds-list',
                                                elem: 'edit-feed',
                                                js: { feedId: item.feedId }
                                            },
                                            {
                                                block: 'i-glue',
                                                elem: 'model-field',
                                                js: {
                                                    block: 'button',
                                                    type: 'mod',
                                                    name: 'lockEdit',
                                                    modName: 'disabled'
                                                }
                                            }
                                        ],
                                        content: iget2('b-feeds-list', 'izmenit-103', 'Изменить')
                                    }
                                ],
                                {
                                    block: 'b-feeds-list',
                                    elem: 'business-type',
                                    content: u.getFeedBusinessTypeText(item.business_type)
                                },
                                item.lastChange,
                                {
                                    block: 'b-feeds-list',
                                    elem: 'campaigns',
                                    elemMods: !(item.campaigns && item.campaigns.length) && { margin: 'yes' },
                                    campaigns: item.campaigns,
                                    isPopupMode: isPopupMode
                                },
                                {
                                    block: 'b-feeds-list',
                                    elem: 'file-name',
                                    //heliarian значения attrs экранируются в кишках i-bem, повторное экранирование не нужно
                                    attrs: { title: sourceName },
                                    content: {
                                        block: 'link',
                                        url: u.sanitizeExternalLink(url),
                                        content: u.hellipSplit(sourceName, 50, u.escapeHTML)
                                    }
                                },
                                {
                                    block: 'b-feeds-list',
                                    elem: 'offers-count',
                                    content: !item.offersCount ?
                                        '&mdash;' :
                                        u.numberFormatter.format(item.offersCount, { precision: 0 })
                                },
                                [
                                    {
                                        block: 'b-feeds-list',
                                        elem: 'status',
                                        elemMods: { status: u.beminize(item.status) },
                                        content: item.statusText
                                    },
                                    //для недавно загруженных элементов (status == 'New'|'Updating') из базы приходит информация о прежних ошибках, так как база обновляется раз в сутки
                                    (['Updating', 'New'].indexOf(item.status) == -1) &&
                                    (item.errorsCount || item.fetchErrorsCount) ?
                                        {
                                            block: 'b-feeds-list',
                                            elem: 'errors',
                                            content: {
                                                block: 'link',
                                                url: u.getUrl('showFeedHistory', {
                                                    feed_id: item.feedId,
                                                    ulogin: u.consts('ulogin'),
                                                    retpath: ctx.pageUrl
                                                }),
                                                target: isPopupMode ? '_blank' : '_self',
                                                content: iget2('b-feeds-list', 'podrobnee', 'Подробнее')
                                            }

                                        } :
                                        '',
                                    item.warningsCount ?
                                        {
                                            block: 'b-feeds-list',
                                            elem: 'warnings',
                                            content: iget2('b-feeds-list', 'preduprezhdeniy-count-kolichestvo-oshibok', 'Предупреждений: {count}', {
                                                count: function() {
                                                    return {
                                                        block: 'link',
                                                        url: u.getUrl('showFeedHistory', {
                                                            feed_id: item.feedId,
                                                            ulogin: u.consts('ulogin'),
                                                            retpath: ctx.pageUrl
                                                        }),
                                                        target: isPopupMode ? '_blank' : '_self',
                                                        content: item.warningsCount
                                                    };
                                                }(iget2('b-feeds-list', 'preduprezhdeniy-count-kolichestvo-oshibok-param-count', 'количество ошибок')),

                                                context: 'count - количество ошибок'
                                            })
                                        } :
                                        ''
                                ]
                            ].map(function(item, index) {
                                return {
                                    elem: 'cell',
                                    mix: [
                                        {
                                            block: 'b-style-table',
                                            elem: 'cell'
                                        },
                                        {
                                            block: 'b-feeds-list',
                                            elem: 'cell',
                                            elemMods: {
                                                // сжимаем первые две ячейки
                                                tiny: index < 2 ? 'yes' : '',
                                                // сжимаем ячейки с сохранением отступов
                                                tight: index == 3 || index > 5 ? 'yes' : ''
                                            }
                                        }
                                    ],
                                    content: item
                                };
                            })
                        };
                    }, this)
                ]
            },
            {
                block: 'button',
                mods: {
                    action: 'delete',
                    disabled: this.ctx.model.deleteDenied ? 'yes' : ''
                },
                mix: [
                    {
                        block: 'b-feeds-list',
                        elem: 'remove-feeds'
                    },
                    {
                        block: 'i-glue',
                        elem: 'model-field',
                        js: {
                            block: 'button',
                            type: 'mod',
                            name: 'deleteDenied',
                            modName: 'disabled'
                        }
                    }
                ],
                content: iget2('b-feeds-list', 'udalit', 'Удалить')
            },
            {
                block: 'b-pager',
                mods: { observable: 'yes' },
                mix: {
                    block: 'b-feeds-list',
                    elem: 'pager'
                },
                currentPage: this.ctx.model.page,
                pageParam: 'page',
                pageUrl: this.ctx.pageUrl.replace(/(\?|&)page=[^&]*(&|$)/, '$2'),
                startFrom: 1,
                totalCount: this.ctx.model.totalCount,
                perpageCount: this.ctx.model.rowsPerPage,
                content: [
                    {
                        elem: 'pages',
                        showFirst: true,
                        showLast: true,
                        pagerRadius: 7
                    }
                ]
            }
        ];
    })
);
