block('b-feeds-list').elem('sort-link').def()(function() {
    var ctx = this.ctx,
        col = ctx.col,
        model = ctx.model || {},
        sort = model.sort || ctx.isDefaultCol && col,
        reverse = model.reverse || 0;

    return applyCtx({
        block: 'link',
        mods: {
            pseudo: 'yes',
            inner: 'yes',
            disabled: this.ctx.model.lockState ? 'yes' : ''
        },
        mix: [
            {
                block: 'b-feeds-list',
                elem: 'sort-link',
                elemMods: { sort: u.beminize(col) },
                js: {
                    sort: col,
                    reverse: col != sort ?
                        0 : reverse ? 0 : 1
                }
            },
            {
                block: 'i-glue',
                elem: 'model-field',
                js: {
                    block: 'link',
                    type: 'mod',
                    name: 'lockState',
                    modName: 'disabled'
                }
            }
        ],
        content: [
            {
                block: 'b-feeds-list',
                elem: 'sort-link-caption',
                tag: 'span',
                content: ctx.content
            },
            col == sort && {
                block: 'b-feeds-list',
                elem: 'sort-link-arrow',
                tag: 'span',
                content: reverse ? '&darr;' : '&uarr;'
            }
        ]
    });
});
