/**
 * Блок списка фидов
 * @param {Number} page номер страницы
 * @param {String} sort название dm поля для сортировки
 * @param {Number} reverse направление сортировки
 * @param {Number} rowsPerPage количество строк на страницу
 */
block('b-feeds-list')(
    js()(function() {
        return {
            modelData: u._.pick(this.ctx, ['page', 'sort', 'reverse', 'rowsPerPage', 'allowEditFeeds']),
            isPopupMode: this.ctx.isPopupMode
        };
    }),

    content()([
        { elem: 'feeds-table' },
        {
            block: 'b-paranja',
            mods: { visible: 'yes' },
            mix: {
                block: 'b-feeds-list',
                elem: 'paranja'
            }
        }
    ])
);
