BEM.DOM.decl({ block: 'b-feeds-list', baseBlock: 'i-glue' }, {

    onSetMod: {

        js: function() {
            this.__base.apply(this, arguments);

            this._renderDebounced = $.debounce(this._render, 0, this);

            this._initEvents();

            this._paranja = this.findBlockOn('paranja', 'b-paranja');
            this._paranja.delMod('visible');
            // если указана страница, то рисуем контент, но даём возможность задать страницу из вне через модель
            this.model.get('page') && this._renderDebounced();
            this.isPopupMode = this.params.isPopupMode;
        }

    },

    /**
     * Показывает/прячет попап редактирования/добавления фида
     * @param {BEM.DOM} button
     * @param {Number} [feedId]
     * @param {Array} [disabledFeeds]
     * @returns {BEM.DOM}
     */
    openFeedEditPopup: function(button, feedId, disabledFeeds) {
        var popup = this._getEditFeedPopup(),
            editPopup;

        if (popup.isShown()) return popup;

        popup
            .setContent(BEMHTML.apply({
                block: 'b-feed-edit-popup',
                disabledFeeds: disabledFeeds,
                feed: feedId && this.model.get('items').getById(feedId).toJSON()
            }))
            .show(button);

        this.model
            // если попап привязан к кнопке внутри списка, то блокируем интерфейс
            .set('lockState', this.containsDomElem(button.domElem))
            // и в любом случае блокируем редактирование других фидов
            .set('lockEdit', true);

        // при скрытии попапа
        popup.onFirst('hide', function() {
            // уничтожаем блок, который сам заботится о завершении процессов сохранения
            editPopup.destruct();

            this.model
                .set('lockState', false)
                .set('lockEdit', false);
        }, this);

        editPopup = popup.findBlockInside('b-feed-edit-popup');

        // если интерфейс не блокируется при открытии попапа,
        // то блокируем/разблокируем его при запросах/ошибках
        !this.model.get('lockState') && editPopup.on('request abort error', function(e) {
            this.model.set('lockState', e.type == 'request');
        }, this);

        editPopup
            .on('save cancel', function() {
                popup.hide();
            }, this)
            .on('save', function() {
                this._render();
            }, this);

        return popup;
    },

    /**
     * Показывает/прячет попап со списком кампаний
     * @param {BEM.DOM} button
     * @param {Object[]} campaigns
     * @param {Boolean} isPopupMode флаг о том, что все ссылки нужно открывать в отдельном окне
     * @returns {BEM.DOM}
     */
    toggleCampaignsPopup: function(button, campaigns, isPopupMode) {
        return this
            ._getCampaignsPopup()
            .setContent(BEMHTML.apply({
                block: 'b-feeds-list',
                elem: 'campaigns',
                elemMods: { list: 'yes' },
                campaigns: campaigns,
                isPopupMode: isPopupMode
            }))
            .toggle(button);
    },

    /**
     * Удаляет блок
     * @param {Boolean} [keepDOM=false] флаг о том, что не надо удалять DOM элемент при разрушении блока
     * @override для удаления попапов
     */
    destruct: function(keepDOM) {
        this._getCampaignsPopup().destruct();
        this._getEditFeedPopup().destruct();

        this.__base(keepDOM);
    },

    /**
     * Отрисовывает список фидов с пагинацией (если есть) согласно
     * текущему состоянию блока
     * @private
     * @fires render:before событие до перерисовки
     * @fires render:after событие после перерисовки
     */
    _render: function() {
        this.trigger('render:before');

        this.model
            .fetch()
            .done(function() {
                BEM.DOM.replace(this.findElem('feeds-table'), BEMHTML.apply({
                    block: 'b-feeds-list',
                    elem: 'feeds-table',
                    pageUrl: u.getCurrentUrl(),
                    model: this.model.toJSON(),
                    isPopupMode: this.isPopupMode
                }));

                this.toggleMod('empty', 'yes', !this.model.get('items').length());

                this.trigger('render:after');
            }.bind(this))
            .fail(function(err) {
                this.trigger('render:after');

                err.message != 'abort' &&
                    BEM.DOM.blocks['b-confirm'].alert(err.message || u['b-feeds-list']['not-found']);
            }.bind(this));
    },

    /**
     * Удаляет выбранные фиды
     * @private
     * @fires remove:before событие до удаления
     * @fires remove:after событие после удаления
     */
    _removeSelected: function() {
        if (this.model.get('deleteDenied')) return;

        this.trigger('remove:before');

        this.model
            .removeSelected()
            .done(function(json) {
                this.trigger('remove:after');

                if (json.length) {
                    // после удаления проверяем необходимость перерисовки
                    this._render();
                } else {
                    BEM.DOM.blocks['b-confirm'].alert(u.pluralizeWord([
                        u['b-feeds-list']['cannot-delete-one'],
                        u['b-feeds-list']['cannot-delete-many'],
                        u['b-feeds-list']['cannot-delete-many']
                    ], this.model.get('selected').length));
                }
            }.bind(this))
            .fail(function(err) {
                this.trigger('remove:after');

                BEM.DOM.blocks['b-confirm'].alert(err.message || u.pluralizeWord([
                    u['b-feeds-list']['cannot-delete-one'],
                    u['b-feeds-list']['cannot-delete-many'],
                    u['b-feeds-list']['cannot-delete-many']
                ], this.model.get('selected').length));
            }.bind(this));
    },

    /**
     * Инициализирует события блока до и после перерисовки, а также
     * перерисовка на события изменения полей VM
     * @private
     */
    _initEvents: function() {
        this
            // разблокируем интерфейс после перерисовки и удаления
            .on('render:after remove:after', function() {
                this._paranja.delMod('visible');
            }, this)
            // перед перерисовкой и удалением блокируем интерфейс + закрываем открытые попапы редактирования
            .on('render:before remove:before', function() {
                this._paranja.setMod('visible', 'yes');
            }, this)
            .on('sort select navigate', function(e, data) {
                var fields = ({
                    sort: ['sort', 'reverse'],
                    select: ['selected'],
                    navigate: ['page']
                })[e.type];

                this.model.update(u._.pick(data, fields));
            })
            // при навигации по страницам прокручиваем страницу вверх
            .on('navigate', function() {
                this.domElem.get(0).scrollIntoView();
            });

        this.model
            .on('lockState', 'change', function(e, data) {
                this.trigger('lockState', { locked: data.value });
            }, this)
            // при сортировке и поиске переходим на первую страницу
            .on('search sort', 'change', function() { this.model.set('page', 1); }, this)
            // перерисовываемся при смене значений полей, меняемых при взаимодействии с пользователем
            .on('page rowsPerPage search sort reverse', 'change', this._renderDebounced, this);
    },

    /**
     * Возвращает ссылку на общий попап со списком кампаний
     * @return {BEM.DOM}
     * @private
     */
    _getCampaignsPopup: function() {
        return BEM.blocks['b-shared-popup'].getInstance({ animate: 'yes' }, { directions: ['bottom-left', 'right'] });
    },

    /**
     * Возвращает ссылку на общий попап редактирования фида
     * @return {BEM.DOM}
     * @private
     */
    _getEditFeedPopup: function() {
        return BEM.blocks['b-shared-popup'].getInstance(
            { animate: 'no', 'has-close': 'yes', autoclosable: 'no' },
            { directions: ['bottom-left', 'right'] }
        );
    }

}, {

    /**
     * Инициализируются live события для перерисовываемых контролов
     * @return {Boolean}
     */
    live: function() {
        this
            // переключатель балуна со списком кампаний в списке фидов
            .liveBindTo('campaigns-popup-button', 'click', function(e) {
                var button = this.findBlockOn(e.data.domElem, 'button');

                if (button.isDisabled()) return;

                this.toggleCampaignsPopup(button, this.elemParams(e.data.domElem).campaigns, this.isPopupMode);
            })
            // кнопка редактирования фида в списке фидов
            .liveBindTo('edit-feed', 'click', function(e) {
                var button = this.findBlockOn(e.data.domElem, 'button');

                if (button.isDisabled()) return;

                this.openFeedEditPopup(button, this.elemParams(e.data.domElem).feedId);
            })
            // кнопка удаления фидов
            .liveBindTo('remove-feeds', 'click', function(e) {
                if (this.findBlockOn(e.data.domElem, 'button').isDisabled()) return;

                this._removeSelected();
            })
            // ссылка для сортировки колонок, хранящая в себе параметры сортировки
            .liveBindTo('sort-link', 'click', function(e) {
                if (this.findBlockOn(e.data.domElem, 'link').hasMod('disabled', 'yes')) return;

                this.trigger('sort', this.elemParams(e.data.domElem));
            })
            // группа чекбоксов, тут интересует только оторванный список значений идентификаторов из значений чекбоксов
            .liveInitOnBlockInsideEvent('change', 'b-checkboxes-group', function(e, data) {
                this.trigger('select', {
                    selected: data.checkboxes.map(function(checkbox) { return +checkbox.val(); })
                });
            })
            // пейджер блокирует переход по своим ссылкам и передает управление пагинацией
            .liveInitOnBlockInsideEvent('navigate', 'b-pager', function(e, data) {
                this.trigger('navigate', {
                    page: data.page
                });
            });

        return false;
    }

});
