/**
 * @namespace
 * @name FilePreloader
 */
BEM.DOM.decl('b-file-preloader', {

    /**
     * @type Attach
     * Блок attach
     */
    _fileAttach: null,

    /**
     * @type object
     * Объект для загрузки файла
     */
    _fileRequest: null,

    /**
     * @type number
     * Таймаут загрузки
     */
    _fileRequestTimeout: 1000,

    onSetMod: {
        js: function() {
            var timeout = this.params.timeout;

            if (timeout) {
                this._fileRequestTimeout = timeout;
            }

            this._spin = this.findBlockInside('spin');
            this._fileAttach = this.findBlockInside('attach');

            this._fileRequest = BEM.create('i-request_type_file', {
                url: this.params.url || u.consts('SCRIPT'),
                type: 'POST',
                dataType: 'json',
                timeout: this._fileRequestTimeout
            });

            this._initEvents();

            this.reset();
        }
    },

    reset: function() {
        this._fileAttach.resetFile();
    },

    /**
     * Вернет расширение выбранного файла
     * @returns {String}
     */
    getExtension: function() {
        return this._fileAttach.val().split('.').pop().toLowerCase();
    },

    /**
     * Обработка массива с ошибками. В зависимости пустой массив или нет будет отображено или скрыто сообщение.
     * @param {Object} [messages]
     * @param {String} [camp]
     * @returns {Boolean}
     */
    processErrors: function(messages, camp) {
        var hasErrors = messages && !!Object.keys(messages).filter(function(name) {
            return messages[name] && messages[name].length;
        }).length;

        BEM.DOM.update(
            camp ? this.elem('error') : this.elem('camp-error'),
            hasErrors ?
                BEMHTML.apply({
                    block: 'b-file-preloader',
                    elem: 'messages',
                    messages: messages,
                    type: camp
                }) :
                ''
        );

        return hasErrors;
    },

    /**
     * Инициализация событий
     * @private
     */
    _initEvents: function() {
        this._fileAttach
            .on('reset', this._onFileInputReset, this)
            .on('change', this._onFileInputChanged, this);
    },

    /**
     * Сброс выбранного файла.
     * @private
     */
    _onFileInputReset: function() {
        this.processErrors();

        this._fileRequest.abort();

        this.trigger('reset');
    },

    /**
     * Загрузка.
     * @private
     */
    _onFileInputChanged: function() {
        var data = this.params.data,
            params = {};

        for (var field in data) {
            params[field] = data[field];
        }

        params.file = this._fileAttach.findElem('control');

        this.trigger('post');

        this._spin.setMod('progress', 'yes');

        this._fileRequest.get(
            params,
            this._afterFileUploaded,
            this._afterFileUploaded,
            { callbackCtx: this });

        this.processErrors();

        this._fileAttach.dropElemCache('control');
    },

    /**
     * Событие, срабатывающее на возврат ответа от сервера, после загрузки.
     * @param {Object|null} data
     * @private
     */
    _afterFileUploaded: function(data) {
        this._spin.delMod('progress');

        if (data && data.statusText === 'abort') {
            this.trigger(data.statusText);

            return;
        }

        if (!data || !data.errors && data.status !== 200) {
            data = { errors: [this.params.errorMessages.defaults] };
        }

        this.trigger(
            this.processErrors({ errors: data.errors }) ? 'error' : 'uploaded',
            data);
    }

});
