BEM.DOM.decl({ block: 'b-floater', modName: 'anchor', modVal: 'yes' }, {

    onSetMod: {
        js: function() {
            // "уходим" в корень документа
            BEM.DOM.append(BEM.DOM.scope, this.domElem);

            this.__base.apply(this, arguments);
        }
    },

    /**
     * Задаёт якорь, на который нужно будет ориентироваться при вычислении момента отрыва
     * @param {jQuery} anchor
     */
    setAnchor: function(anchor) {
        this._anchor = anchor;

        this._offsetTop = null;

        this._checkNeedFreeze();
    },

    /**
     * Выставляет width, paddingLeft и paddingRight элементу content
     * @returns {BEM}
     * @protected
     */
    _setPos: function() {
        var elem = this._anchor || this.domElem,
            cssObj = {
                width: elem.width(),
                paddingLeft: elem.offset().left
            };

        cssObj.paddingRight = this.__self.doc.width() - cssObj.paddingLeft - cssObj.width;

        this.elem('content').css(cssObj);

        return this._setPushOutHeight();
    },

    /**
     * Обработчик события на изменения высоты документа
     * Пересчитывает _offsetTop и вызывает _checkNeedFreeze()
     * @protected
     */
    _heightWindowChanged: function() {
        this._offsetTop = null;

        this._checkNeedFreeze();
    },

    /**
     * Высчитывает offsetTop блока
     * @returns {Number}
     * @protected
     */
    _getOffsetTop: function() {
        return this._offsetTop || (this._offsetTop = (this._anchor || this.domElem).offset().top);
    }

});
