(function($) {

    var blocks = BEM.blocks,
        iResize = blocks['i-resize'].getInstance();

    BEM.DOM.decl({ block: 'b-floater', modName: 'iterate', modVal: 'yes' }, {
        onSetMod: {
            js: function() {
                //все операции из js переехали в init
            }
        },

        /**
         *
         * @param {Object} params
         * @param {Array} params.rows массив BEM-элементов, по которым заполняется флоатер
         * @param {Function} params.onDone - функция заполнения флоатера новым элементом
         */
        init: function(params) {
            var iWinHeightWatcher = blocks['i-height-watcher'].getInstance($('.b-page'));

            this._iterateParams = params;

            iWinHeightWatcher.on('change', this._heightWindowChanged, this);

            this._checkNeedFreezeThrottle = $.throttle(this._checkNeedFreeze, 100, this);

            iResize.on('end', this._onWindowResize, this);

            this.bindToWin('scroll', this._checkNeedFreezeThrottle);

            this._checkNeedFreezeThrottle();
        },

        /**
        * Выставляет width, paddingLeft и paddingRight элементу content
        * height b-floater
        * @returns {BEM}
        * @private
        */
        _setPos: function() {
            // хак, т. к. на странице мультиредактирования, элемент который будет флоатиться занимает всю ширину,
            // то _setPos не нужен, поэтому перекрываем (для DIRECT-39156)
        },

        /**
         * Проверяет нужно ли прилипание
         * @returns {Boolean}
         * @override
         * @private
         */
        _isNeedFreeze: function() {
            var top = this.__self.doc.scrollTop();

            this._position = undefined;

            this._iterateParams.rows.forEach(function(item, i) {
                var offset = item.domElem.offset(),
                    nextItem = this._iterateParams.rows[i + 1];

                if (top >= offset.top &&
                    (!nextItem || top < (offset.top + (nextItem.domElem.offset().top - offset.top) / 2))) {

                    this._position = i;
                }
            }, this);

            return this._position !== undefined;
        },

        /**
         * @override
         * @private
         */
        _checkNeedFreeze: function() {
            if (!this._iterateParams) return;

            this.__base.apply(this, arguments);

            if (this._position !== undefined) {
                this._iterateParams.onDone.call(this, this._iterateParams.rows[this._position]);
            }
        }
    });

})(jQuery);
