BEM.DOM.decl({ block: 'b-floater', modName: 'theme', modVal: 'grey-always' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this.bindToWin('scroll', this._updateWidth);

            this.__self.win.resize(this._updateWidth.bind(this)); //todo: DIRECT-34320

            this._updateWidth();
        }
    },

    /**
     * Проверяет необходимость отрыва блока
     * Переопределён с целью обновления ширины блока
     * @private
     * @override
     */
    _checkNeedFreeze: function() {
        this.__base.apply(this, arguments);

        this._updateWidth();
    },

    /**
     * Обновляет ширину блока
     * @private
     */
    _updateWidth: function() {
        this.afterCurrentEvent(function() {
            if (this.hasMod('fixed', 'yes')) {
                this._resetWidth();
            } else {
                this._setWidth();
            }
        });
    },

    /**
     * Задаёт ширину блока
     * @private
     */
    _setWidth: function() {
        var offset = this.domElem.offset(),
            pageBlock = BEM.blocks['b-page'].getInstance(),
            sidebarBlock = pageBlock.findBlockInside('b-sidebar-dna'),
            userbarBlock = pageBlock.findBlockInside('b-userbar-dna'),
            sidebarBlockWidth = sidebarBlock ? sidebarBlock.domElem.width() : 0,
            userbarBlockWidth = userbarBlock ? userbarBlock.domElem.width() : 0;

        this.elem('bg').css({
            left: '-' + (offset.left - sidebarBlockWidth) + 'px',
            width: pageBlock.domElem.width() - sidebarBlockWidth - userbarBlockWidth + window.pageXOffset + 'px'
        });
    },

    /**
     * Сбрасывает ширину блока
     * @private
     */
    _resetWidth: function() {
        this.elem('bg').css({
            left: '',
            width: ''
        });
    }

});
