(function($) {

    var blocks = BEM.blocks,
        pageBlock = blocks['b-page'].getInstance(),
        iResize = blocks['i-resize'].getInstance(),
        iWinHeightWatcher = blocks['i-height-watcher'];

    BEM.DOM.decl('b-floater', {

        onSetMod: {

            js: function() {
                iWinHeightWatcher
                    .getInstance($('.b-page'))
                    .on('change', this._heightWindowChanged, this);

                this._checkNeedFreeze();

                iResize.on('end', this._onWindowResize, this);

                this.bindToWin('scroll', this._checkNeedFreeze);

                // в ЯБ под Windows воспроизводился баг DIRECT-38151
                this.on('freeze', function() {
                    var height = this._getContentHeight();

                    // поэтому при фризе передергиваем высоту для пересчета css
                    this
                        .domElem
                        .height(0)
                        .height(height);
                });
            },

            fixed: function(modName, modVal) {
                var isFixed = modVal == 'yes';

                this[isFixed ? '_setPos' : '_removePos']();

                this.afterCurrentEvent(function() {
                    this.trigger(isFixed ? 'freeze' : 'unfreeze');
                });

            }

        },

        /**
         * Возвращает высоту плавающего блока с контентом
         * @returns {Number}
         */
        getContentHeight: function() {
            return this._getContentHeight();
        },

        /**
         * Обработчик события на изменения высоты документа
         * Пересчитывает _offsetTop и вызывает _checkNeedFreeze()
         * @private
         */
        _heightWindowChanged: function() {
            this._offsetTop = this.domElem.offset().top;

            this._checkNeedFreeze();
        },

        /**
         * Выставляет width, paddingLeft и paddingRight элементу content
         * height b-floater
         * @returns {BEM}
         * @private
         */
        _setPos: function() {
            var userbarBlock = pageBlock.findBlockInside('b-userbar-dna');

            this.elem('content').css({
                right: userbarBlock ? userbarBlock.domElem.width() : 0
            });

            return this._setPushOutHeight();
        },

        /**
         * Устанавливает блоку новую высоту
         * @returns {BEM}
         * @private
         */
        _setPushOutHeight: function() {
            this.domElem.height(this._getContentHeight());

            return this;
        },

        /**
         * Удаляет атрибут style у блока и элемента content
         * @returns {BEM}
         * @private
         */
        _removePos: function() {
            this.domElem.add(this.elem('content'))
                .removeAttr('style');

            return this;
        },

        /**
         * Устанавливает/снимает прилипание в зависимости от _isNeedFreeze
         * @returns {BEM}
         * @private
         */
        _checkNeedFreeze: function() {
            // если контента нет, то делать блок плоским (иначе занимает место пустой)
            this.toggleMod('flat', 'yes', !this.elem('content').height());

            return this.setMod('fixed', this._isNeedFreeze() ? 'yes' : '');
        },

        /**
         * Проверяет нужно ли прилипание
         * @returns {Boolean}
         * @private
         */
        _isNeedFreeze: function() {
            return this._getOffsetTop() < this.__self.doc.scrollTop();
        },

        _offsetTop: null,

        /**
         * Высчитывает offsetTop блока
         * @returns {Number}
         * @private
         */
        _getOffsetTop: function() {
            return this._offsetTop || (this._offsetTop = this.domElem.offset().top);
        },

        _contentHeight: null,

        /**
         * Высчитывает высоту content
         * @returns {Number}
         * @private
         */
        _getContentHeight: function() {
            return this._contentHeight || (this._contentHeight = this.elem('content').outerHeight());
        },

        _winHeight: null,

        /**
         * Высчитывает высоту окна
         * @returns {Number}
         * @private
         */
        _getWinHeight: function() {
            return this._winHeight || (this._winHeight = this.__self.win.height());
        },

        /**
         * Обработчик события на рейсайз окна
         * при наличии модификатора _fixed_yes вызывает this._setPos()
         * @private
         */
        _onWindowResize: function() {
            this.hasMod('fixed', 'yes') && this._setPos();

            this._checkNeedFreeze();
        },

        /**
         * Удаляет блок
         */
        destruct: function() {
            this.__base.apply(this, arguments);

            iResize.un('end', this._onWindowResize, this);
            iWinHeightWatcher
                .getInstance($('.b-page'))
                .un('change', this._heightWindowChanged, this);
        }

    });

})(jQuery);
