(function() {
/*jshint -W015*/

    var defaultPoint = [0, 0];

/**
 * Собственно карта
 * Элемент реализует обертку над ymaps-api для создания и управления картой
 */
    BEM.DOM.decl({

        block: 'b-form-map',
        elem: 'map'

    }, {

        onSetMod: {

            visibility: {

                visible: function() {

                    this.afterCurrentEvent(this._update);

                }

            }

        },

    /**
     * Обновляет карту в соответствии с переданными параметрами
     * @param {Object} params параметры
     * @param {[Number, Number]} params.point координаты точки
     * @param {[[Number, Number], [Number, Number]]} params.bounds координаты границ карты
     */
        update: function(params) {

            if (params) {
                this.params.point = params.point;
                this.params.bounds = params.bounds;
            }

            this._update();

        },

    /**
     * Переводит карту в исходное состояние
     */
        clear: function() {

            this.params = u._.extend(this.params, this.getDefaultParams());

            this._update();

        },

    /**
     * Обновляет карту
     * @private
     */
        _update: function() {

            var params = this.params,
                point = params.point ? params.point.split(',') : defaultPoint;

            this._map || this._create(point);

            this._placemark && this._placemark.geometry.setCoordinates(point);
            params.bounds ?
                this._map && this._map.setBounds(this._getBoundsSplitted(params.bounds)) :
                this._setZoom(params.point);

        },

    /**
     * Преобразует строковое представление координат границ карты в массив
     * @param {String} bounds координаты
     * @returns {[Array, Array]}
     * @private
     */
        _getBoundsSplitted: function(bounds) {

            var splitted = bounds.split(',');

            return [splitted.slice(0, 2), splitted.slice(2, 4)];

        },

    /**
     * Вычисляет и устанавливает оптимальный коэффициент масштабирования карты
     * @param {[Number, Number]} [point] Координаты центра карты
     * @private
     */
        _setZoom: function(point) {

            var _this = this,
                params = _this.params;

            if (point) {
                _this._map.zoomRange
                    .get(point.split(','))
                    .then(function(range) {
                        _this._map.setZoom(Math.min(params.maxZoom, range[1]));
                    });
                _this._map.setCenter(point.split(','));

            } else {
                _this._map.setZoom(params.zoom);
                _this._map.setCenter(defaultPoint);
            }

        },

    /**
     * Реакция на событие окончания перетаскивания метки на карте
     * @private
     */
        _onPlacemarkDragEnd: function() {

            this.params.point = this._placemark.geometry.getCoordinates().toString();
            this.getParent()._updateByMap();

        },

    /**
     * Создает карту и метку на ней, а также навешивает обработчики событий на них
     * @private
     */
        _create: function(point) {
            var map = this._createMap(point),
                placemark = this._createPlacemark(point);

            map && map.events && map.events.add('boundschange', this._onMapBoundsChange, this);

            placemark && placemark.events && placemark.events.add('dragend', this._onPlacemarkDragEnd, this);

        },

    /**
     * Реакция на ручное изменение границ карты
     * @private
     */
        _onMapBoundsChange: function() {

            this.params.bounds = this._map.getBounds().toString();
            this.getParent().updateBounds();

        },

    /**
     * Создает карту
     * @returns {Map}
     * @private
     */
        _createMap: function(point) {

            var params = this.params,
                state = params.bounds ?
                {
                    type: 'yandex#map',
                    bounds: this._getBoundsSplitted(params.bounds)
                } :
                {
                    type: 'yandex#map',
                    center: point,
                    zoom: params.zoom
                },
                map;

            try {
                map = new ymaps.Map(this.domElem[0], u._.extend(state, {
                    controls: []
                }));

                map.controls
                    .add('zoomControl', { top: 5, left: 5 })
                    .add('typeSelector');
            } catch (e) {}

            return this._map = map;

        },

    /**
     * Создает метку на карте
     * @returns {Placemark}
     * @private
     */
        _createPlacemark: function(point) {

            var params = this.params,
                properties = {
                    iconContent: params.hintContent
                },
                options = {
                    preset: 'islands#lightblueStretchyIcon',
                    draggable: true,
                    hasBalloon: false
                },
                placemark;

            try {
                placemark = new ymaps.Placemark(point, properties, options);
                this._map.geoObjects.add(placemark);
            } catch (e) {}

            return this._placemark = placemark;

        },

    /**
     * Возвращает параметры карты по умолчанию
     * @returns {{point: string, bounds: string, zoom: number, maxZoom: number, hintContent: string}}
     */
        getDefaultParams: function() {

            return {
                point: '',
                bounds: '',
                zoom: 1,
                maxZoom: 16,
                hintContent: 'move me'
            }

        }

    }, {

        live: true

    });

/**
 * Карта в скрытом состоянии
 */
    BEM.DOM.decl({

        block: 'b-form-map',
        elem: 'map',
        modName: 'visibility',
        modVal: 'hidden'

    }, {

        _update: function() {}

    });

})();
