/**
 * Сообщение-индикатор состояния блока
 */
BEM.DOM.decl({

    block: 'b-form-map',
    elem: 'message'

}, {

    /**
     * Обновляет сообщение по ключу
     * Именованный список ключей передается в js-параметре keys элемента
     * @param {String} key ключ сообщения, которое следует показать
     */
    update: function(key) {

        var message = this.findBlockOn('b-message'),
            keys = this.params.keys,
            success = key == 'exact' || key == 'manual';

        message.elem('inner').text(keys[key] || keys.empty || 'status unknown');

        message
            .findBlockOn('icon', 'icon')
            .toggleMod('size-12', 'ok', 'not-ok', success);

    }

}, {

    live: true

});
