block('b-form-map')(
    def()(function() {
        var mapData = this.ctx.data || {};

        return applyNext({
            'mods.mode': 'auto',
            'mods.position': mapData['point-manual'] ? 'manual' : 'auto',
            'mods.status': mapData['point-auto'] ? 'success' : '',
            mapData: mapData
        });
    }),

    elem('position').content()(function() {
        return ['&nbsp;', applyNext()];
    }),

    js()(function() {
        return {
            pointAuto: this.mapData['point-auto'],
            pointManual: this.mapData['point-manual'],
            boundsAuto: this.mapData['bounds-auto'],
            boundsManual: this.mapData['bounds-manual'],
            precision: this.mapData['precision'],
            address: this.mapData['address']
        };
    }),

    mix().match(function() {
        return this.mapData['address'];
    }).match(function() {
        return !this.mapData['point-auto'] || !this.mapData['bounds-auto'] || !this.mapData['precision'];
    })([{
        elem: 'autoinit',
        js: true
    }]),

    elem('head').content()(function() {
        return [
            {
                elem: 'message'
            },
            {
                block: 'b-form-map',
                elem: 'link',
                elemMods: { action: 'toggle' }
            },
            {
                content: {
                    block: 'b-form-map',
                    elem: 'link',
                    elemMods: { action: 'clear' },
                    content: iget2('b-form-map', 'vernut-v-naydennuyu-tochku', 'вернуть в найденную точку')
                }
            }
        ];
    }),

    elem('map')(

        js()(function() {
            return {
                hintContent: iget2('b-form-map', 'peredvinte-metku', 'Передвиньте метку')
            };
        }),

        js().match(function() {
            return this.mapData['point-manual'];
        })(function() {
            var data = applyNext() || {};

            return u._.extend(data, {
                point: this.mapData['point-manual'],
                bounds: this.mapData['bounds-manual']
            });
        })
    ),

    elem('message')(

        def()(function() {
            return applyNext({
                'ctx.keys': {
                    exact: iget2('b-form-map', 'opredeleno-s-tochnostyu-do', 'определено с точностью до дома'),
                    number: iget2('b-form-map', 'opredeleno-s-tochnostyu-do-104', 'определено с точностью до дома, корпус не найден'),
                    near: iget2('b-form-map', 'opredeleno-s-tochnostyu-do-104', 'определено с точностью до дома, корпус не найден'),
                    street: iget2('b-form-map', 'opredeleno-s-tochnostyu-do-105', 'определено с точностью до улицы'),
                    manual: iget2('b-form-map', 'ustanovleno-vruchnuyu', 'установлено вручную'),
                    error: iget2(
                        'b-form-map',
                        'oshibka-pri-opredelenii-adresa',
                        'ошибка при определении адреса; попробуйте сохранить изменения и заново открыть страницу редактирования'
                    ),
                    empty: iget2('b-form-map', 'ne-opredeleno', 'не определено'),
                    other: iget2('b-form-map', 'ne-opredeleno-adres-ne', 'не определено, адрес не найден'),
                    loading: iget2('b-form-map', 'opredelyaetsya-polozhenie', 'определяется положение...')
                },
                'ctx.exact': this.mapData['precision'] == 'exact' || this.mapData['point-manual']
            });
        }),

        js()(function() {
            return {
                keys: this.ctx.keys
            };
        }),

        mix()({ block: 'b-message' }),

        content()(function() {
            return [
                {
                    block: 'b-message',
                    elem: 'icon',
                    elemMods: { 'size-12': this.ctx.exact ? 'ok' : 'not-ok' }
                },
                {
                    block: 'b-message',
                    elem: 'inner',
                    content: this.mapData['point-manual'] ?
                        this.ctx.keys['manual'] :
                        this.ctx.keys[this.mapData['precision'] || 'empty']
                },
                {
                    block: 'b-form-map',
                    elem: 'position',
                    tag: 'span',
                    content: iget2('b-form-map', 'v-s-ot-naydennoy', 'в {s} от найденной точки', {
                        s: {
                            block: this.block,
                            elem: 'distance',
                            tag: 'span'
                        }
                    })
                }
            ];
        })
    )
);
