(function() {

    /**
     * Этот элемент подмешивается к адресным инпутам и карте, а также селекту выбора станции метро
     * При изменении значений адресных инпутов выполняет операции геокодирования на карте и определяет ближайшую станцию метро
     */
    BEM.DOM.decl({

        block: 'b-form-vcard',
        elem: 'geocoder'

    }, {

        onSetMod: {

            js: function() {
                this.__base.apply(this, arguments);

                this._geocodeDebounced = $.debounce(function() {
                    this._geocode();
                }, 1000, this);
            }

        },

        /**
         * Реакция на событие изменения значения одного из адресных инпутов
         * @param {Event} e объект события
         * @param {Object} data данные события
         * @private
         */
        _onInputUpdate: function(e, data) {

            data.type === 'input' && this._geocodeDebounced();
        },

        /**
         * Обходит адресные инпуты и склеивает их значения в строку адреса
         * @returns {string} адрес
         * @private
         */
        _getAddress: function() {

            var country = this.elemInstance('input', 'name', 'country').val().trim(),
                city = this.elemInstance('input', 'name', 'city').val().trim(),
                street = this.elemInstance('input', 'name', 'street').val().trim(),
                house = this.elemInstance('input', 'name', 'house').val().trim(),
                building = this.elemInstance('input', 'name', 'building').val().trim();

            if (!country || !city) return '';

            return [country, city, street, house, building]
                .filter(function(val) {
                    return !!val;
                })
                .join(', ');

        },

        /**
         * Геокодирует адрес и определяет ближайшую станцию метро
         * @private
         */
        _geocode: function() {
            if (this.getParent()._isDestructing) return;

            var map = this.findBlockOn('b-form-map'),
                val = this._getAddress();

            val ? map.setMod('position', 'auto').geocode(val) : map.clear();

            val && this._getMetro();

        },

        /**
         * Определяет ближайшую станцию метро
         * @private
         */
        _getMetro: function() {

            var metro = this.elemInstance('input', 'name', 'metro');

            if (!metro || metro.hasMod('locked')) return;

            var request = this
                .elemInstances('input', 'type', 'input')
                .reduce(function(res, input) {
                    res[input.getMod('name')] = input.val();

                    return res;
                }, {}),
                _this = this;

            this.__self.getRequest(request, function(id) {
                metro.isDisabled() || metro.val(id === null ? '' : id);
                metro.delMod('locked');
                // выставляем модификатор блоку как флаг о том,
                // что автоматический поиск метро имел место быть
                _this.getParent().setMod('metro-init', 'yes');
            });

        }

    }, {

        live: function() {

            this
                .liveInitOnParentEvent('init', function() {
                    this._getMetro();
                })
                .liveInitOnParentEvent('fill', function(e, data) {
                    data['point-auto'] || this._geocode();
                })
                .liveInitOnBlockEvent('update', 'b-form-vcard__input', function(e, data) {
                    this._onInputUpdate(e, data);
                });

        },

        /**
         * Отправляет запрос
         * @param {Object} request параметры геокодирования
         * @param {Function} onSuccess колбек
         */
        getRequest: function(request, onSuccess) {
            BEM.blocks['i-mass-request-factory'].getInstanceFor('ajaxValidateStreet').get({
                country: request.country,
                city: request.city,
                street: request.street,
                house: request.house,
                build: request.building
            },
            function(response) {
                response && response.metro ?
                    onSuccess.call(this, response.metro.region_id) :
                    onSuccess.call(this, null);
            });

        }

    });

})();
