/**
 * С помощью этого модификатора кастомизируются различные инпуты формы
 */

/**
 * Инпуты для ввода страны и города организации
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'input',
    modName: 'name',
    modVals: ['country', 'city']

}, {

    /**
     * Устанавливает значение инпута из переданных данных в соответствии с его модификатором _name
     * @param {Object} data данные для заполнения формы
     * @returns {$.Deferred}
     */
    fill: function(data) {

        this.__base.apply(this, arguments);

        return this._doUpdateRegionRequest();

    },

    /**
     * Реакция на событие выбора значения из саджеста
     * @param {Event} e объект события
     * @param {Object} data данные события
     */
    onInputSelect: function(e, data) {

        var params = data.item.params;

        this.runUpdate({
            geoId: params.geoId,
            phoneCode: params.phoneCode,
            parentId: params.parentId
        });

    },

    /**
     * Реакция на событие выбора неизвестного значения из саджеста
     * Сбрасывает значение саджеста городов и инпутов телефонных кодов при выборе неизвестной страны
     * @param {Event} e объект события
     * @param {Object} data данные события
     */
    onInputSelectUnknown: function(e, data) {

        this.runUpdate({ reset: true });

    },

    /**
     * Запрашивает данные для саджеста для инициирования события выбора страны/города
     * @returns {$.Deferred}
     * @private
     */
    _doUpdateRegionRequest: function() {

        var input = this.findBlockOn('input'),
            // для синхронизации надо использовать промис
            promise = $.Deferred();

        input.hasMod('suggest', 'yes') ?
            input.getDataprovider().get(input.val(), function(data) {
                var params = ((data && data.items || data || [])[0] || [])[1];

                params && this.getParent().trigger('update', {
                    name: this.getMod('name'),
                    geoId: params.geoId,
                    phoneCode: params.phoneCode,
                    parentId: params.parentId
                });

                promise.resolve();

            }.bind(this)) :
            promise.resolve();

        return promise;

    }

});

/**
 * Инпуты для ввода телефонных кодов страны и города организации
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'input',
    modName: 'name',
    modVals: ['phone-code-country', 'phone-code-city']

}, {

    /**
     * Обновляет телефонный код субъекта
     * Имя инпута, возвращающего нужный телефонный код задается js-параметром phoneCodeSource
     * @param {Object} data данные обновившегося инпута
     * @param {String} data.name имя обновившегося инпута
     * @param {String} data.phoneCode Телефонный код субъекта
     */
    update: function(data) {
        //!this.params = true в процессе удаления блока
        if (this.hasMod('locked') || !this.params) return;

        if (data.name != this.params.phoneCodeSource) return;

        if (data.reset) {
            this.val('');
        } else if (data.phoneCode) {
            this.val((this.hasMod('name', 'phone-code-country') ? '+' : '') + data.phoneCode);
        }

    },

    /**
     * Реакция на событие изменения инпута
     * Блокирует инпут для обновления извне при ручной установке значения
     * @param {Event} e объект события
     * @param {Object} data данные события
     */
    onInputChange: function(e, data) {

        this.__base(e, data);

        if (e.block.hasMod('focused', 'yes')) {
            this.toggleMod('locked', 'yes', '', !!e.block.val());
        }

    }

});

/**
 * Инпут для ввода города расположения организации
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'input',
    modName: 'name',
    modVal: 'city'

}, {

    onSetMod: {
        js: function() {
            this.setCountryFilter(this.params.countryId);
        }
    },

    /**
     * Обновляет фильтр по стране в саджесте городов
     * @param {String|Number} [countryId] код страны (не телефонный)
     */
    setCountryFilter: function(countryId) {
        this
            .getInput()
            .getDataprovider()
            .updateParentId(countryId);
    },

    /**
     * Устанавливает идентификатор страны для саджеста городов
     * @param {Object} data
     */
    update: function(data) {
        var params = this.params;

        if (!params) return;

        if (data.name == 'city') {
            params.geoId = data.parentId;
        } else if (data.name == 'country') {
            var geoId = data.geoId;

            if (data.reset || (geoId && geoId != params.countryId)) {
                this
                    .getInput()
                    .val('')
                    .getDataprovider()
                    .updateParentId(geoId);

                params.geoId = geoId || '';
                this.runUpdate({ reset: true });
            }
        }
    }

});

/**
 * Валидация для инпутов страны, города, телефонных кодов страны и города, номера телефона, названия и времени работы организации
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'input',
    modName: 'name',
    modVals: ['country', 'city', 'phone-code-country', 'phone-code-city', 'phone-number', 'name', 'worktime']

}, {

    /**
     * Проверяет инпуты на заполненность
     * @returns {Array}
     */
    validate: function() {

        var result = [],
            val = this.val().trim();

        if (!val) result.push(this.getMod('name') + '_required');

        return result;

    }

});

/**
 * Инпут ввода ОГРН организации
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'input',
    modName: 'name',
    modVal: 'ogrn-new'

}, {

    /**
     * Валидация
     * Выполняется только если введено новое значение ОГРН
     * @returns {Array}
     */
    validate: function() {

        var result = [],
            val = this.val().trim();

        if (this.hasMod('visibility', 'hidden')) return result;

        if (val && !this.validateOGRN(val)) result.push(this.getMod('name') + '_wrong');

        return result;

    },

    /**
     * Проверяет на корректность значение введенного ОГРН
     * @param {String|Number} ogrnNumber номер ОГРН
     * @returns {boolean}
     *
     * копия из data/js/jq/direct/utils.js
     * если обнаружится использование в других местах - перенести в direct.utils
     */
    validateOGRN: function(ogrnNumber) {
        var VALID_OGRN_LENGTH = 13,
            VALID_OGRNIP_LENGTH = 15,
            number = +ogrnNumber,
            sNumber = number + '';

        if (sNumber.length != VALID_OGRN_LENGTH && sNumber.length != VALID_OGRNIP_LENGTH) {
            return false;
        }

        var numberType = sNumber.length == VALID_OGRN_LENGTH ? 'OGRN' : 'OGRNIP',
            numberLength = sNumber.length,
            firstDigit = sNumber.substring(0, 1),
            lastDigitOfNumber = sNumber.substring(numberLength - 1, numberLength),
            leadingNumber = parseInt(sNumber.substring(0, numberLength - 1), 10);

        // The first digit of OGRN/OGRNIP number should be 1, 2, 3 or 5
        if (!firstDigit.match(/[1235]/)) {
            return false;
        }

        var remainder = leadingNumber % (numberType == 'OGRN' ? 11 : 13) + '',
            lessSignificantDigitOfRemainder;

        lessSignificantDigitOfRemainder = remainder < 10 ?
            remainder :
            remainder.charAt(remainder.length - 1);

        return lessSignificantDigitOfRemainder == lastDigitOfNumber;
    }

});
