/**
 * Инпут типа checkbox
 * Подмешивается к блоку checkbox
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'input',
    modName: 'type',
    modVal: 'checkbox'

}, {

    /**
     * Устанавливает/возвращает значение чекбокса
     * @param {String} [val] устанавливаемое значение
     * @returns {String}
     */
    val: function(val) {

        return this.getInput().val(val);

    },

    /**
     * Сбрасывает состояние чекбокса
     */
    clear: function() {

        this.getInput().delMod('checked');

    },

    /**
     * Запускает процедуру обновления формы при изменении состояния чекбокса
     * Добавляет флаг состояния в объект передаваемых данных
     * @param {Event} e объект события
     * @param {Object} data данные события
     */
    onCheckboxChange: function(e, data) {
        this.runUpdate({ checked: e.block.isChecked() }, true);

    }

}, {

    live: function() {

        this.__base();
        this.liveInitOnBlockEvent('change', 'checkbox', function(e, data) {
            this.onCheckboxChange(e, data);
        });

    }

});
