/**
 * Инпут типа input (текстовое поле ввода)
 * Подмешивается к блоку input
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'input',
    modName: 'type',
    modVal: 'input'

}, {

    /**
     * Устанавливает/возвращает значение инпута
     * @param {String} [val] устанавливаемое значение
     * @returns {String}
     */
    val: function(val) {

        return this.getInput().val(val);

    },

    /**
     * Запускает процедуру обновления формы при изменении значения инпута
     * @param {Event} e объект события
     * @param {Object} data данные события
     */
    onInputChange: function(e, data) {

        this.runUpdate();

    },

    /**
     * Запускает процедуру обновления формы при выборе значения из саджеста
     * @param {Event} e объект события
     * @param {Object} data данные события
     */
    onInputSelect: function(e, data) {

        this.runUpdate();

    },

    /**
     * Запускает процедуру обновления формы при выборе неизвестного значения из саджеста
     * @param {Event} e объект события
     * @param {Object} data данные события
     */
    onInputSelectUnknown: function(e, data) {

        this.runUpdate();

    },

    /**
     * Запускает процедуру валидации формы при потере инпутом фокуса
     * @param {Event} e объект события
     * @param {Object} data данные события
     */
    onInputBlur: function(e, data) {

        this._trim();

        this.getParent().validate();

    },

    /**
     * Очищает значение текстового поля от начальных и конечных пробелов
     * @private
     */
    _trim: function() {

        var input = this.getInput();

        input.val(input.val().trim());

    }

}, {

    live: function() {

        this.__base();
        this.liveInitOnBlockEvent('change select select-unknown blur', 'input', function(e, data) {
            switch (e.type) {
                case 'change':
                    this.onInputChange(e, data);
                    break;
                case 'select':
                    this.onInputSelect(e, data);
                    break;
                case 'select-unknown':
                    this.onInputSelectUnknown(e, data);
                    break;
                case 'blur':
                    this.onInputBlur(e, data);
                    break;
            }
        });

    }

});
