block('b-form-vcard').elem('input').elemMod('type', 'select').def()(function() {
    var buttonContent,
        value = this.ctx.value,
        options = this.ctx.options.map(function(option) {
            var attrs = {
                value: option.value
            };

            if (value == option.value) {
                attrs.selected = 'selected';
                buttonContent = option.content;
            }

            return {
                elem: 'option',
                attrs: attrs,
                content: option.content
            };
        });

    return applyCtx({
        block: 'select',
        mods: { disabled: this.ctx.disabled ? 'yes' : '' },
        name: this.ctx.name,
        mix: (this.ctx.mix || []).concat({
            block: 'b-form-vcard',
            elem: 'input',
            elemMods: this.elemMods,
            js: this.ctx.js
        }),
        id: this.ctx.id,
        content: [
            {
                block: 'button',
                attrs: { id: this.generateId() },
                content: buttonContent || (options[0] ? options[0].content : '')
            },
            {
                elem: 'control',
                content: options
            }
        ]
    });
});
