/**
 * Инпут типа select (выпадающий список значений)
 * Подмешивается к блоку select
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'input',
    modName: 'type',
    modVal: 'select'

}, {

    /**
     * Устанавливает/возвращает значение селекта
     * @param {String} [val] устанавливаемое значение
     * @returns {String}
     */
    val: function(val) {

        return this.getInput().val(val);

    },

    /**
     * Запускает процедуру обновления формы при выборе значения селекта
     * Добавляет индекс выбранного значения в объект передаваемых данных
     * @param {Event} e объект события
     * @param {Object} data данные события
     */
    onSelectChange: function(e, data) {

        this.runUpdate({
            index: data.index || this.getInput().getSelectedIndex()
        });

    },

    destruct: function() {
        this.select && this.select.un('change');

        this.__base.apply(this, arguments);
    }

}, {

    live: function() {

        this.__base();
        this.liveInitOnBlockEvent('change', 'select', function(e, data) {
            this.onSelectChange(e, data);
        });

    }

});
