/**
 * Инпут выбора времени работы организации
 * Подмешивается к блоку b-form-worktime
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'input',
    modName: 'type',
    modVal: 'worktime'

}, {

    /**
     * Устанавливает/возвращает значение контрола
     * @param {String} [val] устанавливаемое значение
     * @returns {String}
     */
    val: function(val) {

        return this.getInput().val(val);

    },

    /**
     * Очищает контрол
     */
    clear: function() {

        this.getInput().clear();

    },

    /**
     * Запускает процедуру обновления и валидации формы при изменении состояния контрола
     * @param {Event} e объект события
     * @param {Object} data данные события
     */
    onWorktimeChange: function(e, data) {

        this.runUpdate();
        this.getParent().validate();

    },

    /**
     * Возвращает закэшированный инстанс подмешанного инпута
     * @returns {_input|*|BEM}
     */
    getInput: function() {

        return this._input || (this._input = this.findBlockOn('b-form-worktime'));

    }

}, {

    live: function() {

        this.__base();
        this.liveInitOnBlockEvent('change', 'b-form-worktime', function(e, data) {
            this.onWorktimeChange(e, data);
        });

    }

});
