block('b-form-vcard').elem('input')(

    js()(true),

    elemMod('type', 'input').def()(function() {
        return applyCtx({
            block: 'input',
            id: this.ctx.id,
            name: this.ctx.name,
            mix: (this.ctx.mix || []).concat({ block: 'b-form-vcard', elem: 'input', elemMods: { type: 'input' } }),
            value: this.ctx.value || '',
            content: {
                elem: 'control',
                attrs: { value: this.ctx.value || '' }
            }
        });
    }),

    elemMod('type', 'select').def()(function() {
        var value = this.ctx.value,
            buttonContent,
            options = this.ctx.options.map(function(option, i) {
                var attrs = { value: option.value };

                if (value == option.value) {
                    attrs.selected = 'selected';
                    buttonContent = option.content;
                }

                return {
                    elem: 'option',
                    attrs: attrs,
                    content: option.content
                };
            });

        return applyCtx({
            block: 'select',
            mods: { disabled: this.ctx.disabled ? 'yes' : '' },
            mix: (this.ctx.mix || []).concat({ block: 'b-form-vcard', elem: 'input', elemMods: { type: 'select' } }),
            name: this.ctx.name,
            content: [
                {
                    block: 'button',
                    attrs: { id: this.ctx.id },
                    content: buttonContent || (options[0] ? options[0].content : '')
                },
                {
                    elem: 'control',
                    content: options
                }
            ]
        });
    }),

    elemMod('type', 'checkbox').def()(function() {
        return applyCtx({
            block: 'checkbox',
            mods: { checked: this.ctx.checked ? 'yes' : '' },
            mix: (this.ctx.mix || []).concat({ block: 'b-form-vcard', elem: 'input', elemMods: { type: 'checkbox' } }),
            checkboxAttrs: {
                name: this.ctx.name,
                value: this.ctx.value || ''
            },
            text: this.ctx.label
        });
    }),

    elemMod('type', 'hidden')(

        tag()('input'),

        attrs()(function() {
            return {
                type: 'hidden',
                name: this.ctx.name || '',
                value: this.ctx.value || ''
            };
        })
    ),

    elemMod('type', 'worktime').def()(function() {
        return applyCtx({
            block: 'b-form-worktime',
            mix: (this.ctx.mix || []).concat({ block: 'b-form-vcard', elem: 'input', elemMods: { type: 'worktime' } }),
            name: this.ctx.name,
            value: this.ctx.value
        });
    })
);
