/**
 * Болванка для инпута (поля ввода) формы
 * Тип инпута задается модификатором _type
 * Все методы следует доопределять с помощью модификаторов _type и _name
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'input'

}, {

    /**
     * Устанавливает/возвращает значение инпута
     * @param {*} [val] устанавливаемое значение
     * @returns {*}
     */
    val: function(val) {

        return typeof val === 'undefined' ?
            this.domElem.val() :
            this.domElem.val(val);

    },

    /**
     * Очищает инпут
     */
    clear: function() {

        this.val('');

    },

    /**
     * Запускает процедуру обновления формы при изменении одного из инпутов
     * @param {Object} data дополнительные данные изменившегося инпута
     * @param {Boolean} [ignoreLock=false] игнорировать блокировку и триггерить событие update
     */
    runUpdate: function(data, ignoreLock) {
        if (this.getParent()._isDestructing) return;

        /*jshint indent: false*/
        var updateData = $.extend(
                this.getMods(),
            {
                input: this,
                value: this.val()
            },
                data || {}),
            block = this.getParent();
        //DIRECT-38785
        if (updateData.metroDisabled) { updateData.value = 0; }

        block.update(updateData);
        block.hasMod('lock') && !ignoreLock || this.trigger('update', updateData);
    },

    /**
     * Заглушка для метода обновления инпута
     * Вызывается только у инпутов с модификатором _update_yes
     */
    update: function() {},

    /**
     * Устанавливает значение инпута из переданных данных в соответствии с его модификатором _name
     * @param {Object} data данные для заполнения формы
     */
    fill: function(data) {

        this.val(data[this.params.name] || '');

    },

    /**
     * Метод для валидации инпута
     * Возвращает массив ключей ошибок валидации
     * По умолчанию любой инпут проходит валидацию без ошибок
     * Доопределяется с помощью модификатора _name
     * @returns {Array}
     */
    validate: function() { return [] },

    /**
     * Возвращает имя инпута
     * В качестве имени берется (в порядке убывания приоритета):
     *  1. js-параметр name
     *  2. HTML-атрибут 'name' DOM-ноды, соответствующей инпуту
     * @returns {String}
     */
    getName: function() {
         //this.params не определено при удалении блока
        if (!this.params) return;

        return this.params.name || this.domElem.find('input,select,textarea').attr('name');

    },

    /**
     * Возвращает закэшированный инстанс подмешанного инпута
     * @returns {BEM}
     */
    getInput: function() {

        return this._input || (this._input = this.findBlockOn(this.getMod('type')));

    },

    /**
     * Проверяет, заблокирован ли контрол или нет
     * @returns {Boolean}
     */
    isDisabled: function() {
        return this.getInput().hasMod('disabled', 'yes');
    },

    /**
     * Переводит инпут в неактивное состояние
     */
    disable: function() {

        this._toggleDisabledState(true);

    },

    /**
     * Переводит инпут в активное состояние
     */
    enable: function() {

        this._toggleDisabledState(false);

    },

    /**
     * Хелпер для перевода инпута в активное/неактивное состояние
     * Если инпут был неактивен в момент перевода всей формы в неактивное состояние,
     * то при возврате формы в активное состояние этот инпут останется неактивным
     * @param {Boolean} isDisabled состояние, в которое нужно перевести инпут
     * @private
     */
    _toggleDisabledState: function(isDisabled) {

        var input = this.getInput();

        if (input) {
            if (isDisabled) {
                this._disabled = input.hasMod('disabled');
            } else {
                if (this._disabled) return;
            }
            input.toggleMod('disabled', 'yes', '', isDisabled);
        } else {
            isDisabled ?
                this.domElem.attr('disabled', 'disabled') :
                this.domElem.removeAttr('disabled');
        }
    },

    destruct: function() {
        var input = this.getInput();

        input && input.un('change');

        this.__base.apply(this, arguments);
    }

}, {

    live: true

});
