block('b-form-vcard').elem('item').elemMod('name', 'map')(

    // DIRECT-32676 Оторвать геолокацию в визитке для com.tr
    mix().match(function() {
        return u.consts('yandex_domain') === '//yandex.com.tr';
    })([
        {
            elemMods: { visibility: 'hidden' }
        }
    ]),

    mode('label')(function() {
        return iget2('b-form-vcard', 'polozhenie-na-karte', 'Положение на карте');
    }),

    mode('input')(function() {
        var vcard = this.vcard,
            data = {},
            nameMap = {
                'point-auto': 'auto_point',
                'bounds-auto': 'auto_bounds',
                precision: 'auto_precision',
                'point-manual': 'manual_point',
                'bounds-manual': 'manual_bounds'
            },
            content = [];

        ['point-auto', 'bounds-auto', 'precision', 'point-manual', 'bounds-manual'].forEach(function(name) {
            var formName = nameMap[name],
                val = vcard[formName];

            data[name] = val;
            content.push({
                block: 'b-form-vcard',
                elem: 'map-input',
                tag: 'input',
                attrs: {
                    type: 'hidden',
                    name: formName,
                    value: val || ''
                },
                mix: {
                    block: 'b-form-vcard',
                    elem: 'input',
                    elemMods: {
                        type: 'hidden',
                        name: name
                    },
                    js: { name: formName }
                }
            });
        }, this);

        data.address = ['country', 'city', 'street', 'house', 'build']
            .map(function(name) {
                return vcard[name];
            })
            .filter(function(val) {
                return !!val;
            })
            .join(', ');

        if (data['point-manual'] == data['point-auto']) data['point-manual'] = '';
        if (data['bounds-manual'] == data['bounds-auto']) data['bounds-manual'] = '';

        return {
            block: 'b-form-map',
            mix: [
                {
                    block: 'b-form-vcard',
                    elem: 'map',
                    js: true
                },
                {
                    block: 'b-form-vcard',
                    elem: 'geocoder',
                    js: { id: this.geocoderId }
                }
            ],
            data: data,
            content: [
                content,
                {
                    elem: 'head'
                },
                {
                    elem: 'map'
                }
            ]
        };
    })
);
