block('b-form-vcard').elem('item').elemMod('name', 'metro')(
    def()(function() {
        var vcard = this.vcard,
            disabled = vcard.metro == '0',
            locked = vcard.metro === null || +vcard.metro > 0,
            metroCollection = u.getMetroCollection(),
            metro = [],
            iconSet = {
                213: 'msk',
                2: 'spb',
                143: 'kiev'
            },
            iconType = '';

        vcard && vcard.city ?
            metroCollection.forEach(function(item) {
                if (item.city.toLowerCase() == vcard.city.toLowerCase()) {
                    iconType = iconSet[item.city_id == '1' ? '213' : item.city_id] || '';

                    metro = item.metro.map(function(station) {
                        return {
                            value: station.region_id,
                            content: station.name
                        };
                    });
                }
            }, this) : [];

        return applyNext({
            'ctx.iconSet': iconSet,
            'ctx.disabled': disabled,
            'ctx.locked': locked,
            'ctx.metro': metro,
            'ctx.iconType': iconType
        });
    }),

    mix().match(function() {
        return !this.vcard || !(this.vcard.metro || this.vcard.city && this.ctx.iconType || this.vcard.city_has_metro);
    })([{
        elemMods: { visibility: 'hidden' }
    }]),

    mode('label')(function() {
        return iget2('b-form-vcard', 'stanciya-metro', 'Станция метро');
    }),

    mode('input')(function() {
        return {
            block: 'b-form-vcard',
            elem: 'metro',
            elemMods: { disabled: this.ctx.disabled ? 'yes' : '' },
            disabled: this.ctx.disabled,
            locked: this.ctx.locked,
            id: this.generateId(),
            metroOptions: this.ctx.metro,
            iconSet: this.ctx.iconSet,
            iconType: this.ctx.iconType
        };
    })
);
