block('b-form-vcard').elem('item').elemMod('name', 'region')(

    mode('label')(function() {
        return {
            block: 'b-form-label',
            id: this.generateId(),
            content: iget2('b-form-vcard', 'mestopolozhenie', 'Местоположение')
        };
    }),

    mode('dataprovider')(function() {
        return {
            name: 'input__dataprovider_type_region',
            url: '/registered/main.pl',
            data: {
                cmd: 'ajaxRegionSuggest',
                type: this.region
            }
        };
    }),

    mode('input')(function() {
        return {
            elem: 'layout',
            content: [
                {
                    elem: 'cell',
                    elemMods: { for: 'input-region' },
                    content: {
                        block: 'b-form-vcard',
                        elem: 'input',
                        elemMods: {
                            type: 'input',
                            name: 'country'
                        },
                        js: { name: 'country' },
                        mix: [
                            {
                                block: 'b-form-vcard',
                                elem: 'geocoder',
                                js: { id: this.geocoderId }
                            }
                        ],
                        inputMods: {
                            suggest: 'yes',
                            autoselect: 'yes'
                        },
                        inputJs: {
                            dataprovider: {
                                name: 'input__dataprovider_type_region-static',
                                scriptName: 'countries.js',
                                path: '/'
                            }
                        },
                        name: 'country',
                        value: this.vcard.country,
                        id: this.generateId(),
                        note: iget2('b-form-vcard', 'strana', 'страна')
                    }
                },
                {
                    elem: 'gap'
                },
                {
                    elem: 'cell',
                    elemMods: { for: 'input-region' },
                    content: {
                        block: 'b-form-vcard',
                        elem: 'input',
                        elemMods: {
                            type: 'input',
                            name: 'city',
                            update: 'yes'
                        },
                        js: {
                            name: 'city',
                            countryId: this.vcard.country_geo_id
                        },
                        mix: [
                            {
                                block: 'b-form-vcard',
                                elem: 'geocoder',
                                js: { id: this.geocoderId }
                            }
                        ],
                        inputMods: {
                            suggest: 'yes',
                            autoselect: 'yes'
                        },
                        inputJs: {
                            dataprovider: {
                                name: 'input__dataprovider_type_region-static',
                                scriptName: 'cities.js',
                                path: '/'
                            }
                        },
                        name: 'city',
                        value: this.vcard.city,
                        note: iget2('b-form-vcard', 'gorod', 'город')
                    }
                },
                {
                    elem: 'gap'
                },
                {
                    elem: 'cell',
                    elemMods: { for: 'clear' },
                    content: [
                        !!this.hasCopyFromPrev && [
                            {
                                block: 'link',
                                mods: { pseudo: 'yes' },
                                mix: {
                                    block: 'b-form-vcard',
                                    elem: 'link',
                                    js: true,
                                    elemMods: { action: 'fill' }
                                },
                                content: iget2('b-form-vcard', 'podstavit-iz-predydushchego-obyavleniya', 'подставить из предыдущего объявления')
                            },
                            '<br/>'
                        ],
                        {
                            block: 'link',
                            mods: { pseudo: 'yes', disabled: this.elemMods.disabled },
                            mix: {
                                block: 'b-form-vcard',
                                elem: 'link',
                                js: true,
                                elemMods: { action: 'clear' },
                            },
                            content: iget2('b-form-vcard', 'ochistit-kontaktnuyu-informaciyu', 'очистить контактную информацию')
                        }
                    ]
                }
            ]
        };
    }),

    mode('messages')(function() {
        return {
            elem: 'messages',
            items: {
                country_required: iget2('b-form-vcard', 'strana', 'страна'),
                city_required: iget2('b-form-vcard', 'gorod', 'город')
            }
        };
    })
);
