/**
 * Болванка для ссылок, выполняющих различные действия с формой
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'link'

}, {

    onClick: function(e, data) {}

}, {

    live: function() {

        this
            .liveInitOnBlockEvent('click', 'link', function(e, data) {
                this.onClick(e, data);
            })
            .liveInitOnParentEvent('disabled enabled', function(e, data) {
                switch (e.type) {
                    case 'disabled':
                        this.findBlockOn('link').setMod('disabled', 'yes');
                        break;
                    case 'enabled':
                        this.findBlockOn('link').delMod('disabled');
                        break;
                }
            });

    }

});

/**
 * Ссылка, очищающая форму
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'link',
    modName: 'action',
    modVal: 'clear'

}, {

    /**
     * Реакция на событие клика по ссылке
     */
    onClick: function() {
         //метрика
        try {
            yaCounter191494.reachGoal('CLEAR_CONT');
        } catch (e) { }

        this.getParent().clear();
    }

});

/**
 * ссылка, заполняющая форму данными
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'link',
    modName: 'action',
    modVal: 'fill'

}, {

    /**
     * Реакция на событие клика по ссылке
     */
    onClick: function() {
        var parent = this.getParent(),
            // копируем данные ближайшего объявления, в котором есть модель визитки
            prevBannerData =
                parent.groupModel.getPrevBannerData(
                    parent.bannerModel.get('modelId'),
                    parent.bannerModel.get('ad_type') ? 'text' : undefined),
            data = prevBannerData.vcard,
            isFilled = Object.keys(data || {}).reduce(function(accum, field) {
                // worktime имеет дефолтное значение
                return accum || field !== 'worktime' && data[field];
            }, false);

        if (isFilled) {
            parent.fill(data);
        } else {
            BEM.blocks['b-confirm'].open({
                message: iget2(
                    'b-form-vcard',
                    'vy-uvereny-chto-hotite',
                    'Вы уверены, что хотите скопировать пустую контактную информацию из предыдущего объявления?'
                ),
                onYes: function() {
                    parent.fill(data);
                }
            }, this);
        }

        //метрика
        try {
            yaCounter191494.reachGoal('PREVIOUS_CONT');
        } catch (e) { }
    }

});
