/**
 * Инпут в виде карты для задания координат местоположения организации
 * Подмешивается к блоку b-form-map
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'map'

}, {

    /**
     * Устанавливает/возвращает значение контрола
     * @param {Object} [val] устанавливаемое значение
     * @returns {Object}
     */
    val: function(val) {

        return this.findBlockOn('b-form-map').val(val);

    },

    /**
     * Приводит контрол к исходному состоянию
     */
    clear: function() {

        this.findBlockOn('b-form-map').clear(true);

    },

    /**
     * Реакция на событие изменения в блоке карты
     * Кладет координаты карты в скрытый инпут для последующей отправки на сервер при сабмите формы
     * @param {Event} e объект события
     * @param {Object} data данные события
     */
    onMapChange: function(e, data) {

        this
            .elemInstances('input', 'type', 'hidden')
            .forEach(function(input) {
                var name = input.getMod('name'),
                    val = data[name];

                input.val(val || '');

                this.getParent().update({
                    input: input,
                    name: name,
                    value: val || ''
                });
            }, this);

    },

    /**
     * Заполняет контрол данными
     * @param {Object} data данные
     */
    fill: function(data) {

        // в пришедших данных может быть разный формат
        var nameMap = {
            'point-auto': 'auto_point',
            'bounds-auto': 'auto_bounds',
            precision: 'auto_precision',
            'point-manual': 'manual_point',
            'bounds-manual': 'manual_bounds'
        };

        this.val(
            ['point-auto', 'bounds-auto', 'precision', 'point-manual', 'bounds-manual']
                .reduce(function(res, name) {
                    res[name] = data[name] || data[nameMap[name]] || '';
                    return res;
                }, {}));

    },

    /**
     * Переводит карту в неактивное состояние
     */
    disable: function() {

        this.findBlockOn('b-form-map').setMod('disabled', 'yes');

    },

    /**
     * Переводит карту в активное состояние
     */
    enable: function() {

        this.findBlockOn('b-form-map').delMod('disabled');

    }

}, {

    live: function() {

        this
            .liveInitOnBlockEvent('change', 'b-form-map', function(e, data) {
                this.onMapChange(e, data);
            })
            .liveInitOnParentEvent('clear fill disabled enabled', function(e, data) {
                switch (e.type) {
                    case 'clear':
                        this.clear();
                        break;
                    case 'fill':
                        this.fill(data);
                        break;
                    case 'disabled':
                        this.disable();
                        break;
                    case 'enabled':
                        this.enable();
                        break;
                }
            });

    }

});
