/**
 * Элемент для отображения ошибок валидации
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    elem: 'messages'

}, {

    /**
     * Реакция на событие окончания валидации формы
     * Заполняет контент элемента блоками b-message с сообщениями, соответствующими переданным ключам ошибок валидации
     * Именованный список ключей ошибок валидации передается в js-параметре items
     * @param {Event} e объект события
     * @param {Array} errors массив с ключами ошибок валидации
     * @private
     */
    _onValidate: function(e, errors) {

        var params = this.params,
            items = params['items'] || {},
            result = [];

        Object.keys(items).forEach(
            function(key) {
                if (errors[key])
                    result.push(items[key]);
            });

        BEM.DOM.update(this.domElem, result.length ? BEMHTML.apply({
            block: 'b-message',
            mods: { type: 'error' },
            content: (params.commonText || '') + result.join(', ')
        }) : '');

    }

}, {

    live: function() {

        this.liveInitOnParentEvent('validate', function(e, data) {
            this._onValidate(e, data);
        });

    }

});