block('b-form-vcard').elem('metro')(

    js()(function() {
        return {
            iconSet: this.ctx.iconSet
        };
    }),

    content()(function() {
        return [
            {
                block: 'icon',
                mods: {
                    'size-12': 'metro'
                },
                mix: [{
                    block: this.block,
                    elem: 'icon',
                    elemMods: { metro: this.ctx.iconType }
                }]
            },
            {
                elem: 'input',
                elemMods: {
                    type: 'select',
                    name: 'metro',
                    locked: this.ctx.locked ? 'yes' : ''
                },
                js: { name: 'metro' },
                disabled: this.ctx.disabled,
                name: 'metro',
                value: this.vcard && this.vcard.metro,
                mix: [
                    {
                        block: 'b-form-vcard',
                        elem: 'geocoder',
                        js: { id: this.geocoderId }
                    }
                ],
                id: this.ctx.id,
                options: [{
                    content: iget2('b-form-vcard', 'ne-ukazana', 'не указана'),
                    value: ''
                }].concat(this.ctx.metroOptions || [])
            },
            {
                block: 'checkbox',
                mix: {
                    block: 'b-form-vcard',
                    elem: 'input',
                    elemMods: {
                        type: 'checkbox',
                        update: 'yes'
                    }
                },
                mods: { checked: this.ctx.disabled ? 'yes' : '' },
                checkboxAttrs: {
                    name: 'metro',
                    value: 0
                },
                text: iget2('b-form-vcard', 'ne-pokazyvat-na-poiske', 'не показывать на поиске')
            }
        ];
    })
);
