block('b-form-vcard').elem('ogrn')(

    js()(function() {
        return {
            controlId: this.ctx.id,
            selectName: 'org_details_id',
            inputName: 'ogrn',
            firstOption: {
                value: '',
                content: iget2('b-form-vcard', 'novyy', '-- новый --')
            },
            list: this.ctx.list
        };
    }),

    elemMod('type', 'simple').content()(function() {
        var ctx = this.ctx;

        return {
            block: 'b-form-vcard',
            elem: 'input',
            elemMods: {
                type: 'input',
                name: 'ogrn-new'
            },
            js: { name: 'ogrn' },
            name: 'ogrn',
            value: (ctx.details && ctx.details.ogrn),
            id: ctx.id
        };
    }),

    elemMod('type', 'complex').content()(function() {
        var list = this.ctx.list,
            details = this.ctx.details,
            firstOption = {
                elem: 'option',
                attrs: { value: '' },
                content: iget2('b-form-vcard', 'novyy', '-- новый --')
            },
            selected = false,
            selectedText = null,

            isNewOrn = !details || !details.org_details_id,
            options = [firstOption].concat(list.map(function(item) {
                var attrs = {
                    value: item.org_details_id
                };

                if (!isNewOrn && details && details.org_details_id == item.org_details_id) {
                    attrs.selected = 'selected';
                    selected = true;
                    selectedText = item.ogrn;
                }

                return {
                    elem: 'option',
                    attrs: attrs,
                    content: item.ogrn
                };
            }));

        return {
            elem: 'layout',
            content: [
                {
                    elem: 'cell',
                    elemMods: { for: 'select' },
                    content: {
                        block: 'select',
                        mods: { size: 's', theme: 'normal' },
                        mix: [{
                            block: this.block,
                            elem: 'input',
                            elemMods: {
                                type: 'select',
                                name: 'ogrn'
                            }
                        }],
                        js: { name: 'org_details_id' },
                        name: 'org_details_id',
                        content: [
                            {
                                block: 'button',
                                attrs: { id: this.ctx.id },
                                content: selectedText || firstOption.content
                            },
                            {
                                elem: 'control',
                                content: options
                            }
                        ]
                    }
                },
                {
                    elem: 'gap'
                },
                {
                    elem: 'cell',
                    content: {
                        block: 'b-form-vcard',
                        elem: 'input',
                        elemMods: {
                            type: 'input',
                            name: 'ogrn-new',
                            visibility: selected ? 'hidden' : 'visible'
                        },
                        js: { name: 'ogrn' },
                        name: 'ogrn',
                        value: details && details.ogrn
                    }
                }
            ]
        }
    })
);
