/**
 * Модификатор, включающий кэширование данных формы
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    modName: 'cache',
    modVal: 'yes'

}, {

    /**
     * При наличии сохраненного кэша отдает его при сериализации
     * Иначе - сериализует форму и сохраняет в кэш
     * @param {String} type тип сериализации
     * @returns {*}
     */
    serialize: function(type) {

        if (type === 'object') {
            return this._cache || (this._cache = this.__base(type));
        } else {
            return this.__base(type);
        }

    },

    /**
     * Обновляет закэшированные данные при обновлении формы
     * @param {Object} data данные изменившегося инпута
     */
    update: function(data) {
        if (data && this._cache) {
            this._cache[data.input.getName()] = data.value;
        }

        this.__base(data);

    },

    /**
     * Удаляет кэш при очищении формы
     */
    clear: function() {

        delete this._cache;
        this.__base();

    },

    /**
     * Удаляет кэш при заполнении формы и обновляет фильтр городов по стране
     * @param {Object} data данные для заполнения
     */
    fill: function(data) {
        data = data || {};
        this.elemInstance('input', 'name', 'city').setCountryFilter(data.country_geo_id);
        delete this._cache;
        this.__base(data);
    }

});
