/**
 * Модификатор, включающий валидацию формы
 */
BEM.DOM.decl({

    block: 'b-form-vcard',
    modName: 'validation',
    modVal: 'on'

}, {

    /**
     * Процедура валидации формы
     * Обходит каждый инпут формы и выполняет его метод validate, после чего собирает все ошибки валидации
     *  в единый хэш и генерирует событие окончания валидации, передавая в качестве данных этот хэш
     * @returns {Boolean}
     */
    validate: function() {
        var inputs = this.elemInstances('input'),
            errors = {},
            result = {};

        inputs.forEach(function(input) {
            result[input.getMod('name')] = input.val().trim();
        });

        // да, два цикла, красиво не объединить, т. к. во втором используются результаты от полного прохода первого @collapsus
        inputs.forEach(function(input) {
            // DIRECT-54980 для Турции (код страны +90), если номер телефона начинается на 444, то код города не обязателен
            if (input.getMod('name') == 'phone-code-city' && /^\+?90$/.test(result['phone-code-country']) &&
                /^444/.test(result['phone-number'])) return;

            input.validate().forEach(function(key) {
                errors[key] = true;
            });
        });

        this.trigger('validate', errors);

        return !Object.keys(errors).length;

    },

    /**
     * Запускает процедуру валидации после заполнения формы
     * @param {Object} data данные для заполнения
     */
    fill: function(data) {

        this.__base(data);
        this.validate();

    },

    /**
     * Запускает процедуру валидации после очищения формы
     */
    clear: function() {

        this.__base();
        this.delMod('validation').trigger('validate', {});

    }

});
