block('b-form-vcard')(
    def()(function() {
        return applyNext({
            geocoderId: this.generateId(),
            metroScript: this.ctx.metroScript,
            vcard: this.ctx.vcard || {},
            hasCopyFromPrev: this.ctx.hasCopyFromPrev
        });
    }),

    js()(function() {
        return {
            modelParams: this.ctx.modelParams
        };
    }),

    content()(function() {
        var yaDomain = u.consts('yandex_domain');

        return [
            'region',
            'phone',
            'name',
            'contact-person',
            'worktime',
            'address',
            'map',
            'metro',
            'email',
            'im',
            'details',
            !/yandex.com.tr/.test(yaDomain) && 'ogrn'
        ].map(function(name) {
            return {
                elem: 'item',
                elemMods: { name: name }
            };
        });
    })
);
