BEM.DOM.decl('b-form-vcard', {

    onSetMod: {
        js: function() {
            var modelParams = this.params.modelParams;

            //только на странице редактирования баннера
            if (modelParams) {
                this.bannerModel = BEM.MODEL.getOrCreate(modelParams);
                this.groupModel = BEM.MODEL.getOrCreate({ name: modelParams.parentName, id: modelParams.parentId });
            } else {
                this.model = BEM.MODEL.getOrCreate('m-vcard');
            }
        },

        'metro-init': {
            yes: function() {
                this.trigger('metro-init');
            }
        },

        disabled: function(modName, modVal) {

            this.elemInstances('input').forEach(function(input) {
                modVal ? input.disable() : input.enable();
            });

            this.trigger(modVal ? 'disabled' : 'enabled');

        }

    },

    /**
     * Сериализует форму
     * @param {String} [type] тип сериализованных данных (по умолчанию - массив)
     * @returns {*}
     */
    serialize: function(type) {

        switch (type) {
            case 'object':
                return this._serializeObject();
            default:
                return this._serializeArray();
        }

    },

    /**
     * Сериализует форму и возвращает объект следующего вида: { <имя инпута>: <значение инпута>, ... }
     * @returns {Object|*}
     * @private
     */
    _serializeObject: function() {

        return this
            ._getInputs()
            .reduce(function(res, input) {
                var name = input.getName();

                if (name) res[name] = input.val();

                return res;
            }, {});

    },

    /**
     * Сериализует форму и возвращает массив следующего вида: [ { name: <имя инпута>, value: <значение инпута> }, ... ]
     * @returns {Array|*}
     * @private
     */
    _serializeArray: function() {

        return this
            ._getInputs()
            .map(function(input) {
                return {
                    name: input.getName(),
                    value: input.val()
                };
            });

    },

    /**
     * Возвращает массив блоков элементов __input
     * @returns {Array}
     * @private
     */
    _getInputs: function() {
        return this
            .elemInstances('input')
            .filter(function(input) {
                return !(input.getInput() && input.isDisabled() || input.hasMod('type', 'checkbox') &&
                    !input.getInput().isChecked());
            });
    },

    /**
     * Очищает форму.
     * На время очистки форма блокируется от лишних операций обновления с помощью установки модификатора _lock_yes
     */
    clear: function() {

        this.setMod('lock', 'yes');

        this
            .elemInstances('input')
            .forEach(function(input) {
                input.clear();
            });

        this.trigger('clear').trigger('update', {});

        this.afterCurrentEvent(function() {
            this.delMod('lock');
        });

    },

    /**
     * Вызывает метод update всех инпутов с модификатором _update_yes и генерирует событие update
     * Вызывается из инпута, в котором произошли изменения
     * @param {Object} data данные изменившегося инпута
     * @param {Object} [data.type] тип инпута (напр. input, select, checkbox и т.п.)
     * @param {Object} [data.name] имя инпута
     * @param {Object} data.value значение инпута
     */
    update: function(data) {

        if (this.hasMod('lock') || !this.params) return;

        this
            .elemInstances('input', 'update', 'yes')
            .forEach(function(input) {
                input.update(data);
            });

        this.model && this.model.update(this._serializeObject());
        this.trigger('update', data);

    },

    /**
     * Заполняет форму данными
     * На время заполнения форма блокируется от лишних операций обновления с помощью установки модификатора _lock_yes
     * @param {Object} [data] данные (если не указано - пробуем получить методом getFillData)
     */
    fill: function(data) {
        var allPromises;

        if (!data) return;

        this.setMod('lock', 'yes');

        allPromises = this.elemInstances('input').map(function(input) {
            return input.fill(data);
        });

        $.when.apply($, allPromises).done(function() {
            // Обновляем положение точки на карте, исходя из полученных данных
            this.elemInstance('map').fill(data);

            this.elemInstance('metro').fill(data);

            this.trigger('fill', data).trigger('update', {});

            this.afterCurrentEvent(function() {
                this.delMod('lock');
            });

        }.bind(this));
    },

    /**
     * Заглушка для валидации формы
     */
    validate: function() {}

}, {

    live: true

});
