/**
 * Элемент временного периода
 * Всего таких элементов может быть не более семи (по количеству дней недели)
 */
BEM.DOM.decl({

    block: 'b-form-worktime',
    elem: 'item'

}, {

    onSetMod: {

        js: function() {

            this._daysButtons = this.findBlocksInside('days', 'check-button');
            this._timeSelects = this.findBlocksInside('time', 'select');

        },

        current: {

            yes: function() {

                this._updateByDays();

            }

        },

        empty: function(modName, modVal) {

            this
                .findBlockOn(this.elem('link', 'action', 'select-time'), 'link')
                .setMod('disabled', modVal);

            this._timeSelects.forEach(function(select) {
                select.setMod('disabled', modVal);
            });

        }

    },

    /**
     * Переводит элемент временного периода в неактивное состояние
     */
    disable: function() {

        this._toggleDisabledState(true);

    },

    /**
     * Переводит элемент временного периода в активное состояние
     */
    enable: function() {

        this._toggleDisabledState(false);

    },

    /**
     * Хелпер для перевода элемента временного периода в активное/неактивное состояние
     * @param {Boolean} isDisabled состояние, в которое нужно перевести элемент
     * @private
     */
    _toggleDisabledState: function(isDisabled) {

        var isEmpty = this.hasMod('empty');

        this._daysButtons.forEach(function(button) {
            button.toggleMod('disabled', 'yes', '', isDisabled);
        });

        this._timeSelects.forEach(function(select) {
            select.toggleMod('disabled', 'yes', '', isEmpty || isDisabled);
        });

        this.findBlocksOn(this.elem('link'), 'link').forEach(function(link) {
            this.hasMod(link.domElem, 'action', 'select-time') ?
                link.toggleMod('disabled', 'yes', '', isEmpty || isDisabled) :
                link.toggleMod('disabled', 'yes', '', isDisabled);
        }, this);

    },

    /**
     * Убирает указанный день
     * @param {Number} dayIndex индекс дня, который нужно убрать
     */
    deselectDay: function(dayIndex) {

        this._daysButtons[dayIndex].delMod('checked');

    },

    /**
     * Вычисляет и возвращает выбранные дни
     * @returns {Array}
     * @private
     */
    getDays: function() {

        return this._daysButtons.reduce(
            function(result, button, i) {
                button.isChecked() && result.push(i);
                return result;
            }, []);

    },

    /**
     * Вычисляет и возвращает указанный временной период
     * @returns {Array}
     * @private
     */
    getTime: function() {

        return this._timeSelects.map(
            function(select) {
                return select.val();
            });

    },

    /**
     * Устанавливает указанные дни
     * @param {Array} days массив индексов дней, которые следует установить
     */
    setDays: function(days) {

        this._daysButtons.forEach(function(button, i) {
            button.setMod('checked', (days.indexOf(i) + 1) ? 'yes' : '');
        });

    },

    /**
     * Устанавливает указанные временной период
     * @param {Array} time временной период в виде массива из четырех элементов
     */
    setTime: function(time) {

        this._timeSelects.forEach(function(select, i) {
            select.val(time[i]);
        });

    },

    /**
     * Обновляет элемент при изменении дней
     * @private
     */
    _updateByDays: function() {

        var days = this.getDays();

        this.toggleMod('empty', 'yes', '', !days.length);

        this.getParent().update();

    },

    /**
     * Обновляет элемент при изменении временного периода
     * @private
     */
    _updateByTime: function() {

        this.getParent().update();

    },

    /**
     * Реакция на изменение дней
     * @param {Event} e объект события
     * @private
     */
    _onDaysChange: function(e) {

        if (e.block.isChecked()) {
            this
                .getParent()
                .onSelectDay(this, this._daysButtons.indexOf(e.block));
        }

        this.afterCurrentEvent(this._updateByDays);

    },

    /**
     * Реакция на изменение временного периода
     * @private
     */
    _onTimeChange: function() {

        this.afterCurrentEvent(this._updateByTime);

    },

    /**
     * Реакция на клик по шорткату для выбора временного периода
     * @param {Event} e объект события
     * @private
     */
    _onSelectTime: function(e) {

        this.setTime(this.elemParams(e.block.domElem).time);

    },

    /**
     * Реакция на клик по шорткату для выбора нескольких дней
     * @param {Event} e объект события
     * @private
     */
    _onSelectDays: function(e) {

        this.setDays(this.elemParams(e.block.domElem).days);

    }

}, {

    live: function() {

        this
            .liveInitOnBlockInsideEvent('change', 'check-button', function(e, data) {
                this._onDaysChange(e, data);
            })
            .liveInitOnBlockInsideEvent('change', 'select', function(e, data) {
                this._onTimeChange(e, data);
            })
            .liveInitOnBlockInsideEvent('select-days select-time', 'link', function(e, data) {
                switch (e.type) {
                    case 'select-days':
                        this._onSelectDays(e, data);
                        break;
                    case 'select-time':
                        this._onSelectTime(e, data);
                        break;
                }
            });

    }

});
