block('b-form-worktime')(

    def()(function() {
        return applyNext({
            _name: this.ctx.name,
            _controlId: this.ctx.id,
            _value: this.ctx.value,
            _defaultDays: this.ctx.defaultDays || [0, 1, 2, 3, 4],
            _defaultTime: this.ctx.defaultTime || ['10', '00', '18', '00']
        });
    }),

    js()(function() {
        return {
            defaultDays: this._defaultDays,
            defaultTime: this._defaultTime
        };
    }),

    content()({
        elem: 'content',
        content: { elem: 'items' }
    }),

    content().match(function() {
        return this.ctx.name;
    })(function() {
        return [{
            elem: 'hidden'
        }, applyNext()];
    }),

    elem('hidden')(

        tag()('input'),

        attrs()(function() {
            return {
                type: 'hidden',
                name: this._name,
                value: this._value || '0#4#10#00#18#00'
            };
        })
    ),

    elem('items')(

        mode('items')(function() {
            return [{
                days: this._defaultDays,
                time: this._defaultTime
            }];
        }),

        mode('items').match(function() {
            return this._value;
        })(function() {
            var items = [],
                daysSelected = 0;

            this._value.split(';').forEach(
                function(item) {
                    var splitted = item.split('#'),
                        dayFrom = +splitted[0],
                        dayTo = +splitted[1],
                        days = [],
                        time = splitted.slice(2),
                        merged = false;

                    for (var i = dayFrom; i <= dayTo; i++) days.push(i);

                    items.some(function(pushed, i) {
                        if (time.join() == pushed.time.join()) {
                            items[i].days = pushed.days.concat(days);
                            return merged = true;
                        }
                    });

                    merged || items.push({
                        days: days,
                        time: time
                    });

                    daysSelected += days.length;
                });

            this.ctx.daysSelected = daysSelected;

            return items;
        }),

        def()(function() {
            return applyNext({
                'ctx.items': apply('items', {
                    _value: this.ctx.value || this._value
                })
            });
        }),

        content()(function() {
            var items = this.ctx.items;

            return items.map(function(item, i) {
                var elemMods = item.elemMods = {
                    visibility: 'visible'
                };

                item.elem = 'item';
                item.disabled = this._disabled;

                if (i + 1 == items.length) elemMods.current = 'yes';

                if (!i) {
                    elemMods.position = 'first';
                    item.id = this._controlId;
                }

                return item;
            }, this);
        }),

        mix().match(function() {
            return this.ctx.daysSelected === 7;
        })([{
            elemMods: { 'all-days-selected': 'yes' }
        }])
    )

);
