BEM.DOM.decl('b-form-worktime', {

    onSetMod: {

        disabled: function(modName, modVal) {
            this.elemInstances('item').forEach(function(item) {
                modVal ? item.disable() : item.enable();
            });

            modVal ?
                this.elem('hidden').attr('disabled', 'disabled') :
                this.elem('hidden').removeAttr('disabled');

        }

    },

    onElemSetMod: {
        item: {
            current: {
                yes: function() {
                    this.delMod(this.findElem('item', 'current', 'yes'), 'current');
                }
            }
        }
    },

    /**
     * Реакция на событие клика по кнопке добавления нового элемента временного периода
     * @private
     */
    _onAdd: function() {

        this._addItem();
        this._showItem();

    },

    /**
     * Добавляет новый элемент временного периода
     * При добавлении выбираются еще не выбранные ранее дни недели
     * @private
     */
    _addItem: function() {

        var selectedDays = this
                .elemInstances('item')
                .reduce(function(res, item) {
                    res = res.concat(item.getDays());
                    return res;
                }, []),
            html = BEMHTML.apply({
                block: this.__self.getName(),
                elem: 'item',
                elemMods: { visibility: 'hidden' },
                days: [0, 1, 2, 3, 4, 5, 6].filter(function(day) {
                    return selectedDays.indexOf(day) == -1;
                }),
                time: this.params.defaultTime
            });

        BEM.DOM.append(this.findElem('items'), html);

    },

    /**
     * Показывает добавленный элемент временного периода
     * @private
     */
    _showItem: function() {

        var _this = this,
            items = this.findElem('item'),
            last = items.last();

        this.setMod(last, 'current', 'yes');

        if (items.length == 7) this.setMod(last, 'position', 'last');

        last.slideDown('fast', function() {
            _this.setMod(last.removeAttr('style'), 'visibility', 'visible');
        });

    },

    /**
     * Реакция на событие удаления элемента временного периода
     * @param {Event} e объект события
     * @private
     */
    _onRemove: function(e) {

        this._removeItem(this.closestElem(e.block.domElem, 'item'));

    },

    /**
     * Удаляет элемент временного периода на указанной DOM-ноде
     * @param {jQuery} item DOM-нода, соответствующая элементу временного периода, который нужно удалить
     * @private
     */
    _removeItem: function(item) {

        var _this = this,
            isFirst = _this.hasMod(item, 'position', 'first'),
            isCurrent = _this.hasMod(item, 'current');

        item.slideUp('fast', function() {
            BEM.DOM.destruct(item);

            var items = _this.findElem('item'),
                last = items.last();

            isFirst && _this.setMod(items.first(), 'position', 'first');

            items.length == 1 || _this.delMod(last, 'position');

            isCurrent && _this.setMod(last, 'current', 'yes');

            _this.update();
        });

    },

    /**
     * Вычисляет и возвращает объект суммарного значения контрола
     * @returns {Object|*}
     * @private
     */
    _getSummary: function() {

        var time;

        return this.elemInstances('item').reduce(
            function(result, item) {
                time = item.getTime();
                item.getDays().forEach(function(day) {
                    result[day] = time;
                });
                return result;
            }, {});

    },

    /**
     * Убирает выбранный день из других элементов временного периода
     * @param {BEM} itemSelected элемент временного периода, в котором был выбран день
     * @param {number} dayIndex индекс дня, который был выбран
     */
    onSelectDay: function(itemSelected, dayIndex) {

        this
            .elemInstances('item')
            .forEach(function(item) {
                itemSelected === item || item.deselectDay(dayIndex);
            });

    },

    /**
     * Обновляет блок
     */
    update: function() {

        var isEqual = Object.keys(this._getSummary()).length == 7,
            val = this._val = this._getVal();

        this.toggleMod(this.findElem('items'), 'all-days-selected', 'yes', '', isEqual);

        this.elem('hidden').val(val);
        this.trigger('change', { value: val });

    },

    /**
     * Выбирает указанные дни в первом элементе временного периода
     * Остальные элементы временного периода скрываются
     * @param {Array} days индексы дней, которые нужно выбрать
     * @private
     */
    _clearDays: function(days) {

        var _this = this,
            itemsToHide = _this.findElem('item').slice(1);

        itemsToHide.length ?
            itemsToHide.slideUp(function() {
                BEM.DOM.destruct(itemsToHide);
                _this._selectDays(days);
            }) :
            _this._selectDays(days);

    },

    /**
     * Приводит контрол к исходному состоянию
     */
    clear: function() {

        var params = this.params;

        this._clearDays(params.defaultDays);
        this.elemInstance('item').setTime(params.defaultTime);
        this.update();

    },

    /**
     * Выбирает указанные дни в первом элементе временного периода
     * @param {Array} days индексы дней, которые нужно выбрать
     * @private
     */
    _selectDays: function(days) {

        this
            .elemInstance('item')
            .setMod('current', 'yes')
            .setDays(days);

    },

    /**
     * Устанавливает/возвращает значение контрола в формате 'Д#Д#ЧЧ#ММ#ЧЧ#ММ[;...]'
     * @param {String} val устанавливаемое значение
     * @returns {*|_val}
     */
    val: function(val) {

        return typeof val === 'undefined' ?
            this._val || this._getVal() :
            this._setVal(val);

    },

    /**
     * Устанавливает значение контрола
     * @param {String} val устанавливаемое значение
     * @private
     */
    _setVal: function(val) {

        if (!val) return this.clear();

        BEM.DOM.update(this.elem('content'), BEMHTML.apply({
            block: this.__self.getName(),
            elem: 'items',
            value: val
        }));

        this.update();

    },

    /**
     * Возвращает значение контрола
     * @returns {string}
     * @private
     */
    _getVal: function() {

        var summary = this._getSummary(),
            result = [];

        Object.keys(summary).sort().forEach(function(day) {
            var time = summary[day],
                length = result.length,
                prev = !!length && result[length - 1];

            if (time[2] == '24') time[2] = '00'; // DIRECT-27921

            (prev && (day - 1 == prev[1]) && (time.toString() == prev.slice(2).toString())) ?
                (prev[1] = day) :
                result.push([day, day].concat(time));
        });

        return result.map(function(item) { return item.join('#') }).join(';');

    }

}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('add remove', 'link', function(e, data) {
            switch (e.type) {
                case 'add':
                    this._onAdd(e, data);
                    break;
                case 'remove':
                    this._onRemove(e, data);
                    break;
            }
        });

    },

    /**
     * Сравниваем значения двух временных промежутков
     * @param {String} val1
     * @param {String} val2
     * @returns {Boolean}
     */
    compareWorktime: function(val1, val2) {
        return this._glue(val2) === this._glue(val1);
    },

    /**
     * Склеиваем значения вида 0#4#9#00#21#00;5#6#9#00#21#00 ->  0#6#9#00#21#00
     * @param {String} val
     * @private
     */
    _glue: function(val) {
        var currValueArr,
            prevValueArr,
            res = val.split(';').reduce(function(res, currentValue, i, arr) {
                currValueArr = currentValue.split('#');
                //переводим строки '09' в цифры 9
                currValueArr = currValueArr.map(function(val) {
                    return +val;
                });

                if (i > 0) {
                    prevValueArr = res[res.length - 1];
                    //если совпадает время

                    if ((currValueArr.slice(2).toString() == prevValueArr.slice(2).toString()) &&
                        //и в предыдущем значении предыдущий день недели
                        prevValueArr[1] + 1 == currValueArr[0]) {

                        prevValueArr[1] = currValueArr[1];

                        return res;
                    } else {
                        res.push(currValueArr);

                        return res;
                    }
                } else {
                    res.push(currValueArr);

                    return res;
                }
            }, []);

        return res.map(function(time) { return time.join('#') }).join(';');
    }

});
