block('b-form')(

    attrs()(function() {
        var attrs = applyNext() || {};

        attrs.action = this.ctx.action || '';
        attrs.method = this.ctx.method || 'GET';

        return attrs;
    }),

    content()(function() {
        var res = [];

        this.ctx.header && res.push({
            elem: 'row',
            elemMods: { type: 'header' },
            content: [
                {
                    elem: 'cell',
                    elemMods: { column: 'left' },
                    content: true
                },
                {
                    elem: 'cell',
                    elemMods: { column: 'right' },
                    content: {
                        elem: 'header',
                        content: this.ctx.header
                    }
                }
            ]
        });

        this.ctx.content && res.push(this.ctx.content);

        this.ctx.rows && this.ctx.rows.forEach(function(row) {
            if (!row) return;

            res.push({
                elem: 'row',
                mix: row.mix,
                content: [
                    {
                        elem: 'cell',
                        elemMods: { column: 'left' },
                        content: row.label ?
                            {
                                elem: 'label',
                                mix: row.label.mix,
                                content: row.label.content,
                                attrs: { for: row.label['for'] ? row.label['for'] : '' }
                            } :
                            ''
                    },
                    {
                        elem: 'cell',
                        elemMods: { column: 'right' },
                        content: row.input
                    }
                ]
            });
        });

        this.ctx.hiddenInputs && this.ctx.hiddenInputs.forEach(function(row) {
            if (!row) return;

            res.push({
                elem: 'input',
                mix: row.mix,
                elemMods: { type: 'hidden' },
                attrs: {
                    name: row.name,
                    value: row.value || ''
                },
                name: row.name,
                value: row.value
            });
        });

        this.ctx.submit && res.push({
            elem: 'row',
            elemMods: { type: 'footer' },
            content: [
                {
                    elem: 'cell',
                    elemMods: { column: 'left' },
                    content: true
                },
                {
                    elem: 'cell',
                    elemMods: { column: 'right' },
                    content: ((typeof this.ctx.submit === 'object') && this.ctx.submit) || {
                        block: 'button',
                        mix: [{ block: 'b-form', elem: 'submit' }],
                        type: 'submit',
                        content: this.ctx.submit
                    }
                }
            ]
        });

        return res;
    }),

    elem('header').tag()('h2'),

    elem('label').tag()('label'),

    mod('inner', 'yes').tag()('div')
);
