BEM.DOM.decl('b-form', {
    onSetMod: {
        js: function() {
            var formInputs = this.findBlocksInside('input');

            this.bindTo('submit', this._onSubmit);

            //сабмит формы по enter, если в ней единственный однострочный текстовый инпут
            if (formInputs.length === 1) {
                this.bindTo(formInputs[0].domElem, 'keydown', function(event) {
                    event.which === 13 && this.trigger('submit');
                });
            }
        }
    },

    _onSubmit: function(e) {
        e.preventDefault();
        this.trigger('submit');
    },

    submit: function() {
        //выполняем submit у DOM-элемента формы
        this.domElem[0].submit();
    },

    _getSerializedArray: function() {
        return this.domElem.serializeArray();
    },

    getData: function() {
        var result = {},
            array = this._getSerializedArray();

        array.forEach(function(item) {
            if (result[item.name] !== undefined) {
                if (!$.isArray(result[item.name])) {
                    result[item.name] = [result[item.name]];
                }
                result[item.name].push(item.value || '');
            } else {
                result[item.name] = item.value || '';
            }
        });

        return result;
    }
});
