block('b-freelancer-project-status')(

    def()(function() {
        var data = this.data,
            isClientSupportedByFreelancer = !!(data.login_rights != null &&
                data.login_rights.is_client_supported_by_freelancer),
            freelancer,
            client,
            clientFreelancerData,
            DEFAULT_AVATAR_LINK = 'https://avatars.mds.yandex.net/get-yapic/0/0-0/islands-retina-middle';

        // если кто-то просматривает кампании клиента, которого ведет фрилансер,
        // то показываем плашку с пользователем
        if (isClientSupportedByFreelancer) {
            // если это фрилансер смотрит своего клиента
            // то показываем информацию о клиенте
            client = data.freelancer_related_client;

            if (client) {
                clientFreelancerData = {
                    login: client.login,
                    fullName: client.fio,
                    phone: client.phone,
                    avatarLink: DEFAULT_AVATAR_LINK,
                };
            } else {
                // иначе показываем информацию о фрилансере
                freelancer = this.data.freelancer_info;

                clientFreelancerData = {
                    login: freelancer.login,
                    fullName: freelancer.fio,
                    phone: freelancer.phone,
                    avatarLink: freelancer.avatar_url
                };
            }
        }

        this.ctx.ulogin = data.user_login;
        this.ctx.authorizationData = {
            id: data.uid,
            login: this['i-global'].raw_login,
            isFreelancer: !!(data.login_rights != null && data.login_rights.is_freelancer)
        };
        this.ctx.clientFreelancerData = clientFreelancerData;

        // показываем плашку в случае если авторизованный пользователь - фрилансер или у него есть сотрудничества с фрилансером
        if (this.ctx.authorizationData.isFreelancer || isClientSupportedByFreelancer) {
            return applyNext();
        }
    }),

    js()(function() {
        return {
            ulogin: this.ctx.ulogin,
            authorizationData: this.ctx.authorizationData,
            clientFreelancerData: this.ctx.clientFreelancerData,
            isDirectBirthdayRebrandingEnabled: this.ctx.isDirectBirthdayRebrandingEnabled,
        }
    }),

    content()({
        elem: 'skeleton',
        content: [
            { elem: 'skeleton-text' }
        ]
    })

);
