BEM.DOM.decl('b-freelancer-project-status', {
    onSetMod: {
        js: function() {
            var ulogin = this.params.ulogin,
                authorizationData = this.params.authorizationData,
                clientFreelancerData = this.params.clientFreelancerData,
                isDirectBirthdayRebrandingEnabled = this.params.isDirectBirthdayRebrandingEnabled,
                dna = window.dna;

            if (dna && dna.components && dna.components.FreelancerInfoPanel) {
                this._renderDna(ulogin, authorizationData, clientFreelancerData, dna, isDirectBirthdayRebrandingEnabled);
            }
        }
    },

    onInfoPanelClicked: function(clickType) {
        switch (clickType) {
            case 'FREELANCER':
                BEM.blocks['b-metrika2'].reachGoal({
                    target: 'FREELANCER_INFO_PANEL_CLICK_ON_FREELANCER',
                    params: {
                        URL_click_on_freelancer: document.location.href
                    }
                });
                break;
            case 'MY_PROFILE':
                BEM.blocks['b-metrika2'].reachGoal({
                    target: 'FREELANCER_INFO_PANEL_CLICK_ON_MY_PROFILE',
                    params: {
                        URL_click_on_my_profile: document.location.href

                    }
                });
                break;
            case 'MY_CUSTOMERS':
                BEM.blocks['b-metrika2'].reachGoal({
                    target: 'FREELANCER_INFO_PANEL_CLICK_ON_MY_CUSTOMERS',
                    params: {
                        URL_click_on_my_customers: document.location.href
                    }
                });
                break;
            case 'ALL_SPECIALISTS_BY_FREELANCER':
                BEM.blocks['b-metrika2'].reachGoal({
                    target: 'FREELANCER_INFO_PANEL_CLICK_ON_ALL_SPECIALISTS_BY_FREELANCER',
                    params: {
                        URL_click_on_all_specialists_by_freelancer: document.location.href
                    }
                });
                break;
            case 'ALL_SPECIALISTS_BY_CUSTOMER':
                BEM.blocks['b-metrika2'].reachGoal({
                    target: 'FREELANCER_INFO_PANEL_CLICK_ON_ALL_SPECIALISTS_BY_CUSTOMER',
                    params: {
                        URL_click_on_all_specialists_by_customer: document.location.href
                    }
                });
                break;
            case 'BECOME_SPECIALIST':
                BEM.blocks['b-metrika2'].reachGoal({
                    target: 'FREELANCER_INFO_PANEL_CLICK_ON_BECOME_SPECIALIST',
                    params: {
                        URL_click_on_become_specialist: document.location.href
                    }
                });
                break;
            default:
                throw new Error('An error has occurred in click on the link: "' + clickType + '"');
        }
    },

    /**
     * Render DNA root component
     */
    _renderDna: function(ulogin, authorizationData, clientFreelancerData, dna, isDirectBirthdayRebrandingEnabled) {
        var component = dna.components.FreelancerInfoPanel,
            dnaRootComponent = dna.reactCreateElement(component, {
                clientFreelancerData: clientFreelancerData,
                isClientFreelancerDataLoading: false,
                authorizationData: authorizationData,
                ulogin: ulogin,
                isFreelancerPage: false,
                onInfoPanelClicked: this.onInfoPanelClicked,
                isDirectBirthdayRebrandingEnabled: isDirectBirthdayRebrandingEnabled
            }, null);

        dna.reactDOMRender(dnaRootComponent, this.domElem.get(0));
    }
});
