block('b-freelancers-list')(

    def()(function() {
        var data = this.data,
            csrfToken = this['i-global'].csrf_token,
            columns = [
                {
                    key: 'login',
                    title: iget2('b-freelancers-list', 'login', 'Логин'),
                    transformData: function(row) {
                        var res = [{
                            block: 'link',
                            content: row.login,
                            url: u.formatUrl({
                                host: '/dna/customers',
                                query: {
                                    ulogin: row.login
                                }
                            })
                        }];

                        (row.not_resident === 'Yes') && res.push({
                            block: 'b-freelancers-list',
                            elem: 'login-prop',
                            title: iget2('b-freelancers-list', 'nerezident', 'Нерезидент'),
                            content: ['&nbsp;(', iget2('b-freelancers-list', 'nr', 'нр'), ')']
                        });

                        hasLoginRights('super_control', 'manager_control', 'support_control', 'limited_support_control') && res.push({
                            block: 'b-freelancers-list',
                            elem: 'login-prop',
                            content: [
                                '&nbsp;(',
                                {
                                    block: 'link',
                                    url: u.formatUrl({
                                        host: u.consts('balance_admin'),
                                        path: 'clients.xml',
                                        query: {
                                            login: row.login
                                        }
                                    }),
                                    content: iget2('b-freelancers-list', 'billing', 'биллинг')
                                },
                                ')'
                            ]
                        });

                        return res;
                    }
                },
                {
                    key: 'freelancer_name',
                    title: iget2('b-freelancers-list', 'fio', 'ФИО'),
                    transformData: function(row) {
                        return row.fio || '';
                    }
                },
                {
                    key: 'managers_of_freelancer',
                    title: iget2('b-freelancers-list', 'menedzher', 'Менеджер'),
                    transformData: function(row) {
                        return [
                            row.managers.length > 0 && {
                                elem: 'freelancer-manager-alert',
                                content: iget2('b-freelancers-list', 'frilancer-upravlyaetsya-menedzherom', '!!!Управляется менеджером')
                            },
                            row.managers.map(function(m) {
                                return {
                                    block: 'b-link',
                                    url: 'mailto:' + m.email,
                                    content: m.fio || ''
                                };
                            })
                        ];
                    }
                },
                {
                    key: 'chief_representative',
                    title: iget2('b-freelancers-list', 'glavny_predstavitel', 'Главный представитель'),
                    transformData: function(row) {
                        if (row.is_main_rep === '1') {
                            return iget2('b-freelancers-list', 'glavny_predstavitel101', 'главный представитель');
                        }
                        return row.main_rep_info && (row.main_rep_info.FIO || '' + '&nbsp(' + row.main_rep_info.login || '' + ')');
                    }
                },
                {
                    key: 'phone',
                    title: iget2('b-freelancers-list', 'telefon', 'Телефон'),
                    transformData: function(row) {
                        return row.phone || '';
                    }
                },
                {
                    key: 'email',
                    title: iget2('b-freelancers-list', 'email', 'email'),
                    transformData: function(row) {
                        return row.email ?
                            ({
                                block: 'link',
                                url: 'mailto:' + row.email,
                                content: row.email || ''
                            }) :
                            '';
                    }
                },
                hasLoginRights('support_control', 'super_control', 'limited_support_control' ,'is_developer') && {
                    key: 'edit',
                    sortDisable: true,
                    transformData: function(row) {
                        return row.rbac_role != 'empty' ?
                            ({
                                block: 'link',
                                content: iget2('b-freelancers-list', 'redaktirovat', 'редактировать'),
                                url: u.formatUrl({
                                    host: data.SCRIPT_CLEAR,
                                    query: {
                                        cmd: 'modifyUser',
                                        csrf_token: csrfToken,
                                        ulogin: row.login,
                                        rcmd: 'showSearchPage'
                                    }
                                })
                            }) :
                            '';
                    }
                }
            ];

        return this.ctx.freelancers ? applyNext({
            'ctx.columns': columns
        }) : '';
    }),

    content()(function() {
        var res = [{
            elem: 'header',
            content: iget2('b-freelancers-list', 'frilancery', 'Специалисты') + ':'
        }];

        res.push({
            block: 'b-data-table',
            mix: [
                {
                    block: 'b-freelancers-list',
                    elem: 'table'
                },
                {
                    block: 'b-style-table',
                    mods: {
                        theme: 'gray-list'
                    }
                }
            ],
            mods: {
                sortable: 'server',
                'has-num-column': 'yes'
            },
            columns: this.ctx.columns,
            rows: this.ctx.freelancers,
            mixes: {
                row: [{
                    block: 'b-style-table',
                    elem: 'row'
                }],
                headerRow: [{
                    block: 'b-style-table',
                    elem: 'head'
                }],
                cell: [{
                    block: 'b-style-table',
                    elem: 'cell'
                }],
                headerCell: [{
                    block: 'b-style-table',
                    elem: 'cell'
                }]
            }
        });

        return this.ctx.freelancers.length ?
            res : {
                elem: 'empty-content',
                content: iget2('b-freelancers-list', 'frilancery-ne-naideny', 'Специалисты не найдены.')
            };
    })
);
