/**
 * @event b-gallery-file-chooser#save
 * @type {Object}
 * @property {Object} selectedItem объект файла
 * @property {String} selectedItem.name имя файла
 * @property {String} selectedItem.url ссылка на файл
 * @property {Number} selectedItem.width ширина изображения
 * @property {Number} selectedItem.height высота изображения
 *
 * @fires b-gallery-file-chooser#save событие сохранения одного из файлов из галлереи
 */
BEM.DOM.decl({
    block: 'b-gallery-file-chooser',
    modName: 'type',
    modVal: 'modal',
    implements: 'i-modal-popup-inner-block-interface'
}, {
    onSetMod: {
        js: function() {
            this.__base.apply(this);

            this._cancelButton = this.findBlockOn('cancel', 'button');

            this._cancelButton.on('click', function() {
                this.trigger('cancel');
            }, this);

            this._initSubmitButton();
        }
    },

    /**
     * Показывает блок в модальном окне
     */
    show: function() {
        this._modal && this._modal.show();
    },

    /**
     * Закрывает модальное окно с блоком
     */
    hide: function() {
        this._modal && this._modal.hide();
    },

    /**
     * Были ли изменения
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        // нам нужно, чтобы попап всегда закрывался
        deferred.resolve(false);

        return deferred;
    },

    destruct: function() {
        this._cancelButton.un('click');
        this._submitButton.un('click');
        this._modal && this._modal.un('close', this.resetGallery, this);

        return this.__base.apply(this, arguments);
    },

    /**
     * Устанавливает и инициализирует модальное окно для блока
     * @param {BEM.DOM<b-modal-popup-decorator>} modal блок-декоратор модального попапа
     * @private
     */
    _setModal: function(modal) {
        this._modal = modal;

        this.on('save cancel', this.hide, this);

        this._modal.on('close', this.resetGallery, this);
    },

    /**
     * Инициализирует кнопку сохранения выбранного в галлереи изображения
     * @private
     */
    _initSubmitButton: function() {
        this._submitButton = this.findBlockOn('submit', 'button');

        this.on('select', function() {
            this._submitButton.delMod('disabled');
        }, this);

        this.on('reset', function() {
            this._submitButton.setMod('disabled', 'yes');
        }, this);

        this._submitButton.on('click', function() {
            this.trigger('save', { item: this._selectedItem })
        }, this);
    }
}, {
    /**
     * Создаёт блок для выбора файла из ранее загруженных в модальном окне
     * @param {Object} [ctx] контекст блока
     * @param {Number} [ctx.itemsPerPage] количество элементов файлов на 1 странице
     * @param {Array} ctx.galleryItems массив файлов для загрузки
     * @param {String} ctx.galleryItems.name имя файла
     * @param {String} ctx.galleryItems.url ссылка на файл
     * @param {Number} ctx.galleryItems.width ширина изображения
     * @param {Number} ctx.galleryItems.height высота изображения
     * @returns {BEM.DOM<b-gallery-file-chooser>}
     */
    create: function(ctx) {
        var modal,
            uploader,
            blockJson = {
                block: 'b-gallery-file-chooser',
                mods: {
                    type: 'modal'
                }
            };

        modal = BEM.DOM.blocks['b-modal-popup-decorator'].create2(null, { bodyScroll: false }, $);
        u._.extend(blockJson, ctx || {});
        uploader = modal.setPopupContent(blockJson);
        uploader._setModal(modal);

        return uploader;
    }
});
